<?php

namespace IZON\DataGrid\Render;


use IZON\DataGrid\Column\AColumn;
use IZON\DataGrid\DataGrid;
use IZON\DataGrid\Utils\Constant;
use function IZON\Admin\Forms\getAdminField;

class RenderTable implements IRender {

    /**
     * @param mixed $item
     * @param string[] $setterAttrs
     */
    private static function getTrAttr($item, array $setterAttrs): string {
        $attrs = [];

        if(is_object($item) && method_exists($item, 'getId')) {
            $attrs['data-id'] = $item->getId();
        }

        //        if(!is_null($setterAttrs)) {
        //            $callback = $setterAttrs;
        //            $itemAttrs = $callback($item);
        //            if(is_array($itemAttrs)) {
        //                $attrs = array_merge($attrs, $itemAttrs);
        //            }
        //        }

        $attrParsed = [];
        foreach($attrs as $key => $value) {
            $attrParsed[] = sprintf('%s="%s"', $key, $value);
        }

        return implode(' ', $attrParsed);
    }

    public static function render(DataGrid $dataGrid): void {
        $hash = $dataGrid->getHash();
        $tableName = $dataGrid->getName();
        $datasource = $dataGrid->getDatasource();
        $paginator = $dataGrid->getPaginator();

        $filters = $dataGrid->getFilters();
        $columns = $dataGrid->getColumns();

        $toolbars = $dataGrid->getToolbars();
        $actions = $dataGrid->getActions();
        $groupActions = $dataGrid->getGroupActions();

        $setterAttrs = [];// not yet $dataGrid->get

        $isActionColumns = !empty($actions) || $dataGrid->isSortAble() || $dataGrid->isDetail();

        $totalColumns = count($columns) + ($isActionColumns ? 1 : 0) + (!empty($groupActions) ? 1 : 0);
        ?>
        <table class="datagrid-table table--dynamic <?= $dataGrid->isSortAble() ? 'datagrid-table-sortable' : '' ?>"
               <?php if ($dataGrid->isSortAble()) { ?>
                   data-table-sortable-param="<?= $dataGrid->getName('sortable-data') ?>"
               <?php } ?>
               data-table-name="<?= $tableName ?>"
               data-table-hash="<?= $hash ?>"
               data-link="<?= $dataGrid->createLink() ?>">
            <thead>
                <!-- TOOLBARS -->
                <?php if(count($filters) > 0 && $dataGrid->getRenderFilterType() === Constant::RENDER_FITLER_OUT) { ?>
                    <tr>
                        <td colspan="<?= $totalColumns ?>" class="datagrid-filter-outer">
                            <div class="row">
                                <?php foreach($filters as $key => $filter) { ?>
                                    <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                                        <?php
                                        $params = ['field' => ['attributes' => $filter->getAttributes()]];
                                        echo getAdminField($dataGrid->getFilterForm(), $key, $params);
                                        ?>
                                    </div>
                                <?php } ?>
                                    <div class="col-12 col-sm-6 col-md-4 col-lg-3" style="float: right; text-align: right;">
                                        <span class="form__item__caption--select" style="visibility: hidden;">btn</span>
                                        <span data-link="<?= $dataGrid->createLink([], true) ?>" class="btn btn--small btn--mint datagrid-click-reload-clear"><?= __('Vymazat filtr') ?></span>
                                    </div>
                            </div>
                        </td>
                    </tr>
                <?php } ?>
                <!-- TOOLBARS -->
                <?php if(count($toolbars) > 0 || count($groupActions) > 0) { ?>
                    <tr>
                        <td colspan="<?= $totalColumns ?>" class="datagrid-toolbars">

                            <?php if(count($groupActions) > 0) { ?>
                                <div style="display: inline-block;">
                                    <?= __('Hromadná akce') ?>
                                    <div class="js-datagrid-group-action-box"
                                         style="display: inline-block;"
                                         data-datagrid-group-action-name="<?= $dataGrid->getName('groupAction') ?>"
                                         data-datagrid-group-action-ids="<?= $dataGrid->getName('groupActionIds') ?>">
                                        <?php
                                        foreach($groupActions as $groupAction) {
                                            echo $groupAction->render();
                                        }
                                        ?>
                                        <div style="display: inline-block;">
                                            <span class="js-datagrid-group-action-selected">0</span>/<?= $paginator->getLength() ?>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>

                            <?php if(count($toolbars) > 0) { ?>
                                <div style="display: inline-block; float: right;">
                                    <?php
                                    foreach($toolbars as $toolbar) {
                                        echo $toolbar->render();
                                    }
                                    ?>
                                </div>
                            <?php } ?>

                        </td>
                    </tr>
                <?php } ?>

                <tr>
                    <?php
                    if(!empty($groupActions)) {
                        if(count($filters) === 0 || $dataGrid->getRenderFilterType() === Constant::RENDER_FITLER_OUT) {
                            echo '<th><input type="checkbox" name="group_action_all"></th>';
                        } else {
                            echo '<th></th>';
                        }
                    }

                    foreach($columns as $column) {
                        $column->renderTh();
                    }

                    if($isActionColumns) {
                        echo '<th>'.__('Funkce').'</th>';
                    }
                    ?>
                </tr>

                <?php if(count($filters) > 0 && $dataGrid->getRenderFilterType() === Constant::RENDER_FILTER_IN) { ?>
                    <tr>
                        <?php
                        if(!empty($groupActions)) {
                            echo '<th><input type="checkbox" name="group_action_all"></th>';
                        }

                        foreach(array_keys($columns) as $key) {
                            if(isset($filters[$key])) {
                                $params = ['raw' => true, 'field' => ['attributes' => $filters[$key]->getAttributes()]];
                                echo '<th>'.getAdminField($dataGrid->getFilterForm(), $key, $params).'</th>';
                            } else {
                                echo '<th></th>';
                            }
                        }

                        if($isActionColumns) {
                            echo '<th></th>';
                        }
                        ?>
                    </tr>
                <?php } ?>
            </thead>

            <tbody>
                <?php foreach($datasource->getData() as $item) { ?>
                    <tr <?= self::getTrAttr($item, $setterAttrs) ?>>
                        <?php
                        if(!empty($groupActions)) {
                            ?>
                            <td class="datagrid-align-center datagrid-column-group-action">
                                <input type="checkbox" name="group_action[]" value="<?= $item->getId() ?>">
                            </td>
                            <?php
                        }

                        foreach($columns as $column) {
                            $column->renderTd($item);
                        }

                        if($isActionColumns) {
                            ?>
                            <td class="datagrid-align-center datagrid-column-action">
                                <?php
                                foreach($actions as $action) {
                                    echo $action->render($item);
                                }

                                if($dataGrid->isSortAble()) {
                                    echo '<i class="fas fa-fw fa-arrows-alt-v js-datagrid-sortable-handle"></i>';
                                }

                                if($dataGrid->isDetail() && method_exists($item, 'getId')) {
                                    $detailHref = $dataGrid->createLink(['datagrid-detail' => $item->getId()]);
                                    echo sprintf('<a href="%s" class="js-datagrid-load-detail"><i class="fas fa-fw fa-eye"></i></a>', $detailHref);
                                }
                                ?>
                            </td>
                            <?php
                        }
                        ?>
                    </tr>
                <?php } ?>

                <?php if($paginator->getItemCount() === 0) { ?>
                    <tr>
                        <td colspan="<?= $totalColumns ?>"
                            style="color: darkgrey; padding: 2rem 1rem; font-size: 125%;">
                            <?= __('Nebyly nalezeny žádné záznamy...') ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
        <?php
    }

    public static function renderBoxStart(DataGrid $dataGrid): void {
        echo '<div class="datagrid-table-box">';
    }

    public static function renderBoxEnd(DataGrid $dataGrid): void {
        echo '</div>';
    }
}
