<?php

namespace IZON\DataGrid\Column;

use function AdminPHPView\getModuleActionURL;

class ColumnModuleLink extends AColumn {

    /** @var string */
    protected $method;

    /** @var array */
    protected $params;

    /** @var boolean */
    protected $targetBlank;

    /** @var string */
    protected $controllerId;

    public function __construct(
        string  $key,
        string  $name,
        string  $method,
        array   $params,
        bool    $targetBlank = false,
        ?string $column = null,
        ?string $controllerId = null
    ) {
        parent::__construct($key, $name, $column);

        $this->method = $method;
        $this->params = $params;
        $this->targetBlank = $targetBlank;
        $this->controllerId = $controllerId ?? $this->module->getControllerId();
    }

    public function setTargetBlank(bool $targetBlank = true): self {
        $this->targetBlank = $targetBlank;
        return $this;
    }

    protected function render($item): string {
        $params = [];
        foreach($this->params as $key => $prop) {
            $property = $this->getProperty($item, $prop);
            if($property) {
                $params[$key] = $property;
            }
        }

        $link = getModuleActionURL(
            $this->controllerId,
            $this->method,
            $params,
            $this->module->getIdentifier()
        );
        $target = $this->targetBlank ? ' target="_blank"' : null;

        return sprintf('<a href="%s"%s>%s</a>', $link, $target, parent::render($item));
    }

}
