<?php

namespace IZON\DataGrid\GroupAction;

class GroupAction extends AGroupAction {

    /** @var array */
    protected $options;

    public function __construct(string $key, ?string $name, ?callable $callback = null, array $options = []) {
        parent::__construct($key, $name, $callback);

        $this->options = $options;
    }

    public function render(): string {
        return sprintf('<option value="%s">%s</option>', $this->key, $this->renderName());
    }

    public function getKey(): string {
        return $this->key;
    }

    public function getValue(): string {
        return $this->name;
    }

    public function setOptions(array $options): void {
        $this->options = $options;
    }

    public function getOptions(): array {
        return $this->options;
    }

}
