<?php

declare(strict_types=1);

namespace IZON\DataGrid\Exception;

use Exception;

class DataGridColumnException extends Exception {

    public function __construct($item, string $column, $code = 0, \Throwable $previous = null) {
        if(is_object($item)) {
            $message = sprintf('Entity [%s] haven\'t public getter for property [%s]', get_class($item), $column);
        } else {
            $message = sprintf('Array haven\'t key [%s]', $column);
        }

        parent::__construct($message, $code, $previous);
    }
}
