<?php

declare(strict_types=1);

namespace IZON\DataGrid\Exception;

use Exception;

class DataGridFilterExistException extends Exception {

    public function __construct(string $key, $code = 0, \Throwable $previous = null) {
        $message = sprintf('Filter with key [%s] is already set', $key);
        parent::__construct($message, $code, $previous);
    }
}
