<?php

namespace IZON\DataGrid\Column;


class ColumnAbsLink extends AColumn {

    /** @var bool */
    protected $targetBlank;

    public function __construct(string $key, string $name, bool $targetBlank = false, ?string $column = null) {
        parent::__construct($key, $name, $column);

        $this->targetBlank = $targetBlank;
    }

    public function setTargetBlank(bool $targetBlank = true): self {
        $this->targetBlank = $targetBlank;
        return $this;
    }

    protected function render($item): string {
        $value = parent::render($item);
        $target = $this->targetBlank ? ' target="_blank"' : null;

        return sprintf('<a href="%s"%s>%s</a>', $value, $target, $value);
    }
}
