<?php

namespace IZON\DataGrid\Action;


use function PHPView\getControllerURL;

class ActionLink extends AAction {

    /** @var string */
    protected $controllerId;

    /** @var array */
    protected $params;

    /** @var string|null */
    protected $method;

    public function __construct(string $key, ?string $name, string $controllerId, array $params = [], ?string $method = null) {
        parent::__construct($key, $name);

        $this->controllerId = $controllerId;
        $this->params = $params;
        $this->method = $method;
    }

    public function render($item = null): string {
        $params = [];
        foreach($this->params as $key => $prop) {
            $property = $this->getProperty($item, $prop);
            if($property) {
                $params[$key] = $property;
            }
        }

        $link = getControllerURL($this->controllerId, $params, $this->method);
        $target = $this->targetBlank ? ' target="_blank"' : null;

        return sprintf('<a href="%s"%s>%s</a>', $link, $target, $this->renderName());
    }

}
