<?php

namespace IZON\DataGrid\Render;

use IZON\DataGrid\DataGrid;

class RenderScript implements IRender {

    private static $wasRendered = false;

    public static function render(DataGrid $dataGrid): void {
        if(self::$wasRendered) {
            return;
        }
        self::$wasRendered = true;
        ?>
        <script>
            $(function () {

                // sortable
                function initSortAble() {
                    $('.datagrid-table-sortable').each(function () {

                        if ($(this).hasClass('datagrid-table-sortable-init')) {
                            $(this).sortable('destroy');
                        }

                        $(this).addClass('datagrid-table-sortable-init')
                            .sortable({
                                placeholder: 'js-datagrid-sortable-highlight',
                                items: 'tbody tr',
                                handle: '.js-datagrid-sortable-handle',
                                update: function (e, ui) {
                                    let $item = $(ui.item);

                                    let itemId = $item.data('id');
                                    let prevId = $item.prev().data('id') ? $item.prev().data('id') : null;
                                    let nextId = $item.next().data('id') ? $item.next().data('id') : null;

                                    let data = {};
                                    data[$(this).data('table-sortable-param')] = [itemId, prevId, nextId].join(';');

                                    $.ajax({
                                        method: 'GET',
                                        url: $(this).data('link'),
                                        data: data,
                                        success: function (response) {
                                            $item
                                                .animate({backgroundColor: '#BBFFBE'}, 250)
                                                .animate({backgroundColor: ''}, 2500);
                                        }
                                    });
                                }
                            });
                        ;

                    });
                }

                initSortAble();

                // group action
                $(document).on('click', '.datagrid-table tbody td', function (e) {
                    if (e.target !== this) {
                        return;
                    }

                    $(this).closest('tr')
                        .find('input[name="group_action[]"]')
                        .trigger('click');
                });

                $(document).on('change', 'input[name="group_action_all"]', function () {
                    let $table = $(this).closest('table');

                    $table.find('input[name="group_action[]"]')
                        .prop('checked', $(this).prop('checked'));

                    updateSelectedGroupAction($table);
                });

                function updateSelectedGroupAction($table) {
                    let countSelected = $table.find('input[name="group_action[]"]:checked').length;
                    $table.find('.js-datagrid-group-action-selected').text(countSelected);

                    if (countSelected > 0) {
                        $table.find('.js-datagrid-group-action-box > *:not(.js-datagrid-group-action-export)')
                            .css('opacity', '')
                            .css('pointer-events', '');
                    } else {
                        $table.find('.js-datagrid-group-action-box > *:not(.js-datagrid-group-action-export)')
                            .css('opacity', 0.5)
                            .css('pointer-events', 'none');
                    }

                    if ($table.find('input[name="group_action[]"]:checked').length === $table.find('input[name="group_action[]"]').length) {
                        $table.find('input[name="group_action_all"]').prop('checked', true);
                    } else {
                        $table.find('input[name="group_action_all"]').prop('checked', false);
                    }
                }

                $('.datagrid-table').each(function () {
                    updateSelectedGroupAction($(this));
                });

                $(document).on('change', 'input[name="group_action[]"]', function () {
                    updateSelectedGroupAction($(this).closest('table'));
                });

                $(document).on('change', 'select[name="group_action_select"]', function () {
                    $('select[name^="group_action_select_multi"]').hide();

                    if ($(this).find('option:selected').hasClass('js-datagrid-group-action-select-options')) {
                        $('select[name^="group_action_select_multi[' + $(this).val() + ']"]').show();
                    }
                });

                $(document).on('click', '.js-datagrid-group-action', function () {
                    let $table = $(this).closest('table');
                    let $groupActionBox = $table.find('.js-datagrid-group-action-box');
                    let link = $table.data('link');

                    let selected = [];
                    $table.find('input[name="group_action[]"]:checked').each(function () {
                        selected.push($(this).val());
                    });

                    let action = null;
                    if ($(this).hasClass('js-datagrid-group-action-select')) {
                        let $select = $table.find('select[name="group_action_select"]');

                        action = $select.val();

                        if ($select.find('option:selected').hasClass('js-datagrid-group-action-select-options')) {
                            let value = $('select[name^="group_action_select_multi[' + $select.val() + ']"]').val();

                            if (value === '') {
                                return;
                            }

                            action += '::' + value;
                        }
                    } else {
                        action = $(this).data('datagrid-group-action');
                    }

                    if (!action) {
                        return;
                    }

                    let data = {};
                    data[$groupActionBox.data('datagrid-group-action-name')] = action;
                    data[$groupActionBox.data('datagrid-group-action-ids')] = selected;

                    reloadGridByGroupAction($(this), link, data);
                });

                var datagridReload = null;
                $(document).on('change keyup', '.datagrid-reload', function () {
                    let $that = $(this);

                    clearTimeout(datagridReload);
                    datagridReload = setTimeout(function () {
                        reloadGrid($that, $that.find('option:selected').data('link'));
                    }, 500);

                    return false;
                });

                var lastFilters = {};
                $(document).on('change keyup', '.datagrid-reload-input', function () {
                    let $that = $(this);

                    clearTimeout(datagridReload);
                    datagridReload = setTimeout(function () {
                        let data = {};

                        let key = $that.data('datagrid-param-name');

                        if (lastFilters[key] !== $that.val()) {
                            data[key] = $that.val();
                            lastFilters[key] = $that.val()

                            let link = $that.data('link');
                            if (!link) {
                                link = $that.closest('.datagrid-table').data('link')
                            }

                            reloadGridByForm($that, link, data);
                        }
                    }, 1000);

                    return false;
                });

                $(document).on('click', 'a.datagrid-reload', function () {
                    reloadGrid($(this), $(this).attr('href'))
                    return false;
                });

                // reload grids fnc
                function reloadGrid($caller, link) {
                    $.get(link, function (response) {
                        reloadGridResponse($caller, link, response);
                    });
                }

                function reloadGridByForm($caller, link, data) {
                    link = removeParam($caller.attr('data-datagrid-param-name'), link);
                    let newLink = link;
                    $.ajax({
                        method: 'GET',
                        url: link,
                        data: data,
                        beforeSend: function (tmp, data) {
                            newLink = data.url;
                        },
                        success: function (response) {
                            reloadGridResponse($caller, newLink, response);
                            let $input = $('[data-datagrid-param-name="' + $caller.attr('data-datagrid-param-name') + '"]');
                            let value = $input.val();

                            $input.focus().val('').val(value);
                        }
                    });
                }

                function reloadGridByGroupAction($caller, link, data) {
                    if ($caller.hasClass('js-datagrid-group-action-export')) {
                        $.get({
                            method: 'GET',
                            url: link,
                            data: data,
                            beforeSend: function (tmp, data) {
                                window.location = data.url;
                            }
                        });
                    } else {
                        $.ajax({
                            method: 'GET',
                            url: link,
                            data: data,
                            success: function (response) {
                                reloadGridResponse($caller, link, response);
                            }
                        });
                    }
                }

                function reloadGridResponse($caller, link, response) {
                    let e_link = link.split('?');
                    e_link[0] = window.location.pathname;
                    link = e_link.join('?');

                    window.history.pushState({"html": response}, "", link);

                    $caller.closest('.datagrid-table-box')
                        .html(response);

                    initSortAble();
                }

                // remove param from url
                function removeParam(key, sourceURL) {
                    var rtn = sourceURL.split("?")[0],
                        param,
                        params_arr = [],
                        queryString = (sourceURL.indexOf("?") !== -1) ? sourceURL.split("?")[1] : "";
                    if (queryString !== "") {
                        params_arr = queryString.split("&");
                        for (var i = params_arr.length - 1; i >= 0; i -= 1) {
                            param = params_arr[i].split("=")[0];
                            if (param === key) {
                                params_arr.splice(i, 1);
                            }
                        }
                        rtn = rtn + "?" + params_arr.join("&");
                    }
                    return rtn;
                }
            });
        </script>
        <?php
    }
}

