<?php

namespace IZON\DataGrid\Column;


class ColumnLink extends AColumn {

    /** @var callable */
    protected $linkCallback;

    /** @var boolean */
    protected $targetBlank;

    public function __construct(string $key, string $name, callable $linkCallback, bool $targetBlank = false, ?string $column = null) {
        parent::__construct($key, $name, $column);

        $this->linkCallback = $linkCallback;
        $this->targetBlank = $targetBlank;
    }

    public function setTargetBlank(bool $targetBlank = true): self {
        $this->targetBlank = $targetBlank;
        return $this;
    }

    protected function render($item): string {
        $callable = $this->linkCallback;
        $target = $this->targetBlank ? ' target="_blank"' : null;

        return sprintf('<a href="%s"%s>%s</a>', $callable($item), $target, parent::render($item));
    }
}
