CKEDITOR.on('instanceReady', function (ev) {
    ev.editor.on('key', function (evt) {
        if (evt.data.keyCode === 3342368) { // ctrl+shift+space
            evt.cancel();
            evt.editor.insertHtml('○');//&nbsp;');
        }
    });

    ev.editor.setData(ev.editor.getData().replace(/&nbsp;/g, '○'));
});

document.addEventListener('submit', function (e) {
    if (e.target.tagName === 'FORM') {
        e.preventDefault();
        e.stopPropagation();

        $.each(CKEDITOR.instances, function (index, editor) {
            editor.setData(editor.getData().replace(/○/g, '&nbsp;'));
        });

        e.target.submit();
    }
});
