<?php

namespace IZON\Cache\Impl;

use Doctrine\Common\Cache\RedisCache as DoctrineRedisCache;
use IZON\Cache\ICache;
use Redis;

/**
 * 
 */
class RedisCache implements ICache {
    
    /**
     * @var DoctrineRedisCache
     */
    protected $cache;
    
    protected $lifetime = 0;

    
    public function __construct(Redis $redis) {
        $this->cache = new DoctrineRedisCache();
        $this->cache->setRedis($redis);
    }

    public function delete($uid) {
        $this->cache->delete($uid);
    }

    public function deleteAll() {
        $this->cache->deleteAll();
    }

    public function get($uid) {
        return $this->cache->fetch($uid);
    }

    public function has($uid) {
        return $this->cache->contains($uid);
    }

    public function save($uid, $value) {
        $this->cache->save($uid, $value, $this->lifetime);
    }
    
    public function setLifetime($lifetime) {
        $this->lifetime = $lifetime;
    }

    public function setPrefix($prefix) {
        $this->cache->setNamespace($prefix);
    }

}
