<?php

namespace IZON\Cache;

/**
 * basic cache interface
 * @author Lukáš Linhart <linhart@izon.cz>
 */
interface ICache {

    /**
     * save value to cache 
     * @param string $uid
     * @param mixed $value
     */
    public function save($uid, $value);

    /**
     * check if value exists
     * @param string $uid
     */
    public function has($uid);

    /**
     * 
     * @param string $uid
     * @return mixed 
     */
    public function get($uid);

    /**
     * delete value from cache
     * @param string $uid
     */
    public function delete($uid);

    /**
     * delete all values
     */
    public function deleteAll();
    /**
     * set lifetime in seconds
     * 0 => do not expire
     * @param integer $lifetime
     */
    public function setLifetime($lifetime);
    /**
     * prefix for uid
     * @param string $prefix
     */
    public function setPrefix($prefix);
}
