<?php

namespace IZON\Cache\Impl;

use Doctrine\Common\Cache\FilesystemCache as DoctrineFileSytemCache;
use IZON\Cache\ICache;

/**
 * cache stored on filesystem in specified directory
 */
class FileSytemCache implements ICache {
    
    /**
     * @var DoctrineFileSytemCache
     */
    protected $cache;
    
    protected $lifetime = 0;

    
    public function __construct($directory) {
        $this->cache = new DoctrineFileSytemCache($directory);
    }

    public function delete($uid) {
        $this->cache->delete($uid);
    }

    public function deleteAll() {
        $this->cache->deleteAll();
    }

    public function get($uid) {
        $this->cache->fetch($uid);
    }

    public function has($uid) {
        $this->cache->contains($uid);
    }

    public function save($uid, $value) {
        $this->cache->save($uid, $value, $this->lifetime);
    }
    
    public function setLifetime($lifetime) {
        $this->lifetime = $lifetime;
    }

    public function setPrefix($prefix) {
        $this->cache->setNamespace($prefix);
    }

}
