<?php

namespace IZON\Cache\Impl;

use Doctrine\Common\Cache\ArrayCache as DoctrineArrayCache;
use IZON\Cache\ICache;

/**
 * Description of ArrayCache
 *
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class ArrayCache implements ICache {
    /**
     *
     * @var DoctrineArrayCache
     */
    protected $cache;
    
    protected $lifetime = 0;

    public function __construct() {
        $this->cache = new DoctrineArrayCache();
    }

    public function delete($uid) {
        $this->cache->delete($uid);
    }

    public function deleteAll() {
        $this->cache->deleteAll();
    }

    public function get($uid) {
        $this->cache->fetch($uid);
    }

    public function has($uid) {
        $this->cache->contains($uid);
    }

    public function save($uid, $value) {
        $this->cache->save($uid, $value, $this->lifetime);
    }
    
    public function setLifetime($lifetime) {
        $this->lifetime = $lifetime;
    }

    public function setPrefix($prefix) {
        $this->cache->setNamespace($prefix);
    }

}
