<?php

declare(strict_types=1);

namespace IZON\Application\Tools\Rector\MVC;

use IZON\MVC\Interceptors\Interceptor;
use PhpParser\Node;
use PhpParser\Node\Expr\ConstFetch;
use PhpParser\Node\Name;
use PhpParser\Node\Stmt\Class_;
use PhpParser\Node\Stmt\Nop;
use PhpParser\Node\Stmt\Return_;
use Rector\Rector\AbstractRector;
use Symplify\RuleDocGenerator\ValueObject\CodeSample\CodeSample;
use Symplify\RuleDocGenerator\ValueObject\RuleDefinition;

final class ReturnNullInEmptyInterceptorPreHandleRector extends AbstractRector
{
    public function getRuleDefinition(): RuleDefinition
    {
        return new RuleDefinition('Add return to preHandle method of Interceptor', [new CodeSample(
            <<<'CODE_SAMPLE'
class InterceptorImpl implements Interceptor
{
    public function preHandle(...)
    {
    }
}
CODE_SAMPLE
            ,
            <<<'CODE_SAMPLE'
class InterceptorImpl implements Interceptor
{
    public function preHandle(...)
    {
        return null;
    }
}
CODE_SAMPLE
        )]);
    }
    /**
     * @return array<class-string<Node>>
     */
    public function getNodeTypes(): array
    {
        return [Class_::class];
    }

    /**
     * @param Class_ $node
     */
    public function refactor(Node $node): ?Class_
    {
        $isInterceptor = false;
        foreach ($node->implements as $implement) {
            if ($this->isName($implement, Interceptor::class)) {
                $isInterceptor = true;
                break;
            }
        }
        if (!$isInterceptor) {
            return null;
        }

        $preHandleMethod = $node->getMethod('preHandle');
        if ($preHandleMethod === null) {
            return null;
        }

        foreach ($preHandleMethod->stmts as $stmt) {
            if (!$stmt instanceof Nop) {
                return null;
            }
        }

        $preHandleMethod->stmts[] = new Return_(new ConstFetch(new Name('null')));

        return $node;
    }
}
