<?php

declare (strict_types=1);
namespace IZON\Application\Tools\Rector\Config\Sets;

use IZON\Utils\StringUtils;
use Rector\Config\RectorConfig;
use Rector\Transform\Rector\FuncCall\FuncCallToStaticCallRector;
use Rector\Transform\ValueObject\FuncCallToStaticCall;

return static function (RectorConfig $rectorConfig) : void {
    $rectorConfig->rules([FuncCallToStaticCallRector::class]);
    $rectorConfig->ruleWithConfiguration(FuncCallToStaticCallRector::class, [
        new FuncCallToStaticCall('IZON\String\startsWith', StringUtils::class, 'startsWith'),
        new FuncCallToStaticCall('IZON\String\endsWith', StringUtils::class, 'endsWith')
    ]);
};
