<?php

declare (strict_types=1);
namespace IZON\Application\Tools\Rector\Config\Sets;

use IZON\MVC\Config;
use IZON\Admin\Config as AdminConfig;
use Rector\Config\RectorConfig;
use Rector\Transform\Rector\FuncCall\FuncCallToStaticCallRector;
use Rector\Transform\ValueObject\FuncCallToStaticCall;

return static function (RectorConfig $rectorConfig) : void {
    $rectorConfig->rules([FuncCallToStaticCallRector::class]);

    $configClass = Config::class;
    if (class_exists(AdminConfig::class)) {
        $configClass = AdminConfig::class;
    }
    $methods = ['appDir', 'appSubDir', 'tmpSubDir', 'cacheSubDir'];
    $rectors = [];

    foreach ($methods as $method) {
        if (method_exists(Config::class, $method)) {
            $rectors[] = new FuncCallToStaticCall('IZON\DI\MVC\\' . $method, $configClass, $method);
        }
    }

    $rectorConfig->ruleWithConfiguration(FuncCallToStaticCallRector::class, $rectors);
};
