<?php

declare (strict_types=1);
namespace IZON\Application\Tools\Rector\Config\Sets;

use IZON\Forms\Fields\BaseField;
use IZON\Forms\Form;
use IZON\Forms\FormSet;
use Rector\Config\RectorConfig;
use Rector\Renaming\Rector\MethodCall\RenameMethodRector;
use Rector\Renaming\ValueObject\MethodCallRename;

return static function (RectorConfig $rectorConfig) : void {
    $rectorConfig->rules([RenameMethodRector::class]);
    $rectorConfig->ruleWithConfiguration(RenameMethodRector::class, [
        new MethodCallRename(FormSet::class, 'getDinamicFormDefinition', 'getDynamicFormDefinition'),
        new MethodCallRename(FormSet::class, 'getDinamicFormDefinitions', 'getDynamicFormDefinitions'),
        new MethodCallRename(FormSet::class, 'createDinamicForm', 'createDynamicForm'),
        new MethodCallRename(FormSet::class, 'getDinamicFormsCount', 'getDynamicFormsCount'),
        new MethodCallRename(FormSet::class, 'getDinamicForms', 'getDynamicForms'),
        new MethodCallRename(FormSet::class, 'addDinamicFormDefinition', 'addDynamicFormDefinition'),
        new MethodCallRename(Form::class, 'getErrorsArray', 'getFieldErrors'),
        new MethodCallRename(Form::class, 'getFileds', 'getFields'),
        new MethodCallRename(Form::class, 'addFiled', 'addField'),
        new MethodCallRename(BaseField::class, 'getRequired', 'isRequired'),
    ]);
};
