<?php

declare (strict_types=1);
namespace IZON\Application\Tools\Rector\Config\Sets;

use IZON\DI\DI;
use Rector\Config\RectorConfig;
use Rector\Transform\Rector\FuncCall\FuncCallToStaticCallRector;
use Rector\Transform\ValueObject\FuncCallToStaticCall;

return static function (RectorConfig $rectorConfig) : void {
    $config = [
        new FuncCallToStaticCall('IZON\DI\create', DI::class, 'create'),
        new FuncCallToStaticCall('IZON\DI\object', DI::class, 'autowire'),
        new FuncCallToStaticCall('IZON\DI\env', DI::class, 'env'),
        new FuncCallToStaticCall('IZON\DI\factory', DI::class, 'factory'),
        new FuncCallToStaticCall('IZON\DI\get', DI::class, 'get'),
        new FuncCallToStaticCall('IZON\DI\link', DI::class, 'link'),
        new FuncCallToStaticCall('IZON\DI\string', DI::class, 'string'),
        new FuncCallToStaticCall('IZON\DI\value', DI::class, 'value'),
        // forgotten php-di functions
        new FuncCallToStaticCall('DI\create', DI::class, 'create'),
        new FuncCallToStaticCall('DI\object', DI::class, 'autowire'),
        new FuncCallToStaticCall('DI\env', DI::class, 'env'),
        new FuncCallToStaticCall('DI\factory', DI::class, 'factory'),
        new FuncCallToStaticCall('DI\get', DI::class, 'get'),
        new FuncCallToStaticCall('DI\link', DI::class, 'link'),
        new FuncCallToStaticCall('DI\string', DI::class, 'string'),
        new FuncCallToStaticCall('DI\value', DI::class, 'value'),
    ];

    if(method_exists(DI::class, 'factoryObject')) {
        $config[] = new FuncCallToStaticCall('IZON\DI\factoryObject', DI::class, 'factoryObject');
        $config[] = new FuncCallToStaticCall('IZON\DI\factoryBean', DI::class, 'factoryObject');
    }

    $rectorConfig->ruleWithConfiguration(FuncCallToStaticCallRector::class, $config);
};
