<?php

declare (strict_types=1);
namespace IZON\Application\Tools\Rector\Config\Sets;

use IZON\Application\Tools\Rector\DB\AddAnnotationQueryResultRector;
use IZON\Application\Tools\Rector\DB\AddAnnotationToDaoRector;
use IZON\Application\Tools\Rector\DB\EntityAddStrictTypeFromAnnotationRector;
use Rector\Config\RectorConfig;
use Rector\Renaming\Rector\MethodCall\RenameMethodRector;
use Rector\Renaming\Rector\Name\RenameClassRector;
use Rector\Renaming\ValueObject\MethodCallRename;

return static function (RectorConfig $rectorConfig) : void {
    $rectorConfig->rules([
        RenameMethodRector::class,
        AddAnnotationToDaoRector::class,
        AddAnnotationQueryResultRector::class,
        EntityAddStrictTypeFromAnnotationRector::class
    ]);

    $rectorConfig->ruleWithConfiguration(RenameMethodRector::class, [
        new MethodCallRename('IZON\DB\QueryHelpers', 'getClassCoumnName', 'getClassColumnName'),
        new MethodCallRename('IZON\DB\QueryHelpers', 'getCoumnName', 'getColumnName'),
    ]);
    $rectorConfig->ruleWithConfiguration(RenameClassRector::class, [
        'IZON\DB\TransactionManagementFactoryBean' => 'IZON\DB\TransactionManagementFactoryObject',
    ]);
};
