<?php

declare (strict_types=1);
namespace IZON\Application\Tools\Rector\Config\Sets;

use IZON\DBLocale\Dao\CountryDao;
use IZON\DBLocale\Dao\CurrencyDao;
use IZON\DBLocale\Dao\DBCountryDao;
use IZON\DBLocale\Dao\DBCurrencyDao;
use IZON\DBLocale\Dao\DBLanguageDao;
use IZON\DBLocale\Dao\DBLocaleDao;
use IZON\DBLocale\Dao\LanguageDao;
use IZON\DBLocale\Dao\LocaleDao;
use IZON\DBLocale\Domain\Country;
use IZON\DBLocale\Domain\Currency;
use IZON\DBLocale\Domain\DBCountry;
use IZON\DBLocale\Domain\DBCurrency;
use IZON\DBLocale\Domain\DBLanguage;
use IZON\DBLocale\Domain\DBLocale;
use IZON\DBLocale\Domain\Language;
use IZON\DBLocale\Domain\Locale;
use Rector\Config\RectorConfig;
use Rector\Renaming\Rector\MethodCall\RenameMethodRector;
use Rector\Renaming\Rector\Name\RenameClassRector;
use Rector\Renaming\ValueObject\MethodCallRename;

return static function (RectorConfig $rectorConfig) : void {
    $rectorConfig->rules([RenameClassRector::class, RenameMethodRector::class]);
    $rectorConfig->ruleWithConfiguration(RenameClassRector::class, [
        Country::class => DBCountry::class,
        Currency::class => DBCurrency::class,
        Language::class => DBLanguage::class,
        Locale::class => DBLocale::class,
        CountryDao::class => DBCountryDao::class,
        CurrencyDao::class => DBCurrencyDao::class,
        LanguageDao::class => DBLanguageDao::class,
        LocaleDao::class => DBLocaleDao::class,
    ]);
    $rectorConfig->ruleWithConfiguration(RenameMethodRector::class, [
        new MethodCallRename(DBCountry::class, 'getLocaleCode', 'getLocaleTag'),
    ]);
};
