<?php

declare (strict_types=1);
namespace IZON\Application\Tools\Rector\Config\Sets;

use IZON\Admin\Config;
use IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;
use Rector\Config\RectorConfig;
use Rector\Renaming\Rector\Name\RenameClassRector;
use Rector\Transform\Rector\FuncCall\FuncCallToStaticCallRector;
use Rector\Transform\ValueObject\FuncCallToStaticCall;

return static function (RectorConfig $rectorConfig) : void {

    $rectorConfig->ruleWithConfiguration(RenameClassRector::class, [
        'IZON\Admin\Services\SessionService' => LoggedAdminUserSessionServiceInterface::class,
    ]);

    $configClass = Config::class;
    $methods = ['moduleConfig', 'moduleConfigs', 'moduleGet', 'moduleIdentifier', 'modulesDirs'];
    $rectors = [];
    foreach ($methods as $method) {
        if (method_exists(Config::class, $method)) {
            $rectors[] = new FuncCallToStaticCall('IZON\Admin\DI\\' . $method, $configClass, $method);
        }
    }

    $rectorConfig->ruleWithConfiguration(FuncCallToStaticCallRector::class, $rectors);
};
