<?php

/**
 * initializes doctrine console tool
 * @see https://www.doctrine-project.org/projects/doctrine-orm/en/current/reference/tools.html#doctrine-console
 */

namespace IZON\Application\Tools\DB;

use Doctrine\ORM\Tools\Console\ConsoleRunner;
use Doctrine\ORM\Tools\Console\EntityManagerProvider\SingleManagerProvider;
use IZON\Admin\Config;
use IZON\DB\EntityManagerInterface;
use IZON\MVC\AppConfigInterface;
use Psr\Container\NotFoundExceptionInterface;
use RuntimeException;

/**
 * $_composer_autoload_path defined by composer if file handled as vendor-binaries
 * https://getcomposer.org/doc/articles/vendor-binaries.md
 */
if (!isset($_composer_bin_dir)) {
    throw new \Exception('$_composer_bin_dir variable not defined');
}
$appDir = dirname(dirname($_composer_bin_dir));

/** @var AppConfigInterface $appConfig */
$appConfig = require $appDir . '/app-config-factory.php';
$appConfig->init();

try {
    $entityManager = $appConfig->getContainer()->get(Config::DEFAULT_DB_ENTITY_MANAGER_IDENTIFIER);
} catch (NotFoundExceptionInterface $exception) {
    throw new RuntimeException(Config::DEFAULT_DB_ENTITY_MANAGER_IDENTIFIER . ' id not defined in application container');
}

$commands = [
    // If you want to add your own custom console commands,
    // you can do so here.
];
ConsoleRunner::run(
    new SingleManagerProvider($entityManager),
    $commands
);
