<?php

namespace IZON\Admin\Web\Controllers;

use Exception;

use \IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * 
 */
class SwitchCountryController implements Controller {
    
    /**
     * @var LoggedAdminUserSessionServiceInterface
     */
    protected $sessionService;
    
    /**
     * @var string|null na ktery controller se ma presmerovat po znene nastaveni zeme
     */
    protected $redirectCotrollerIdentifier = NULL;

    protected $countryCodeParamName = "countryCode";


    public function __construct(LoggedAdminUserSessionServiceInterface $sessionService,
                                $redirectCotrollerIdentifier) {
        $this->sessionService = $sessionService;
        $this->redirectCotrollerIdentifier = $redirectCotrollerIdentifier;
    }
    
    public function execute(HttpRequest $request) {
        if( !$request->hasParameter($this->countryCodeParamName) ) {
            throw new Exception("Neobsahuje parametr countryCode pro změnu jazyka");
        }
        
        $countryCode = $request->getParameter($this->countryCodeParamName);
        $this->sessionService->setSelectedCountry($countryCode);
        
        $modelAndView = ModelAndView::createControllerRedirect($this->redirectCotrollerIdentifier, []);
        return $modelAndView;
    }
}
