<?php

namespace IZON\Admin\Web\Controllers;

use IZON\Admin\Services\AdminServiceInterface;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * controller, ktery zobrazuje dashboard
 */
class DashboardController implements Controller {
    
    /**
     * @var AdminServiceInterface
     */
    protected $adminService;
    
    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string 
     */
    protected $dashboardViewName = "admin/dashboard";

    
    public function __construct(AdminServiceInterface $adminService) {
        $this->adminService = $adminService;
    }
    
    public function execute(HttpRequest $request) {
        $modelAndView = new ModelAndView($this->dashboardViewName);
        return $modelAndView;
    }
}
