<?php

namespace IZON\Admin\Domain;

use Doctrine\ORM\Mapping as ORM;

/**
 * setting for some module
 *
 */
#[ORM\Entity]
#[ORM\Table(name: "core_admin_module_settings")]
class AdminModuleSetting {

    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    #[ORM\ManyToOne(targetEntity: AdminModule::class, inversedBy: "moduleSettings")]
    #[ORM\JoinColumn(name: "fk_admin_module_id", referencedColumnName: "id")]
    protected ?AdminModule $module = null;

    /**
     * @var string unikatni identifikator daneh modulu
     */
    #[ORM\Column]
    protected string $paramIdentifier = '';

    /**
     * @var string hodnota nastaveni
     */
    #[ORM\Column]
    protected string $value = '';

    /**
     * @var string pojmenovani promene
     */
    #[ORM\Column]
    protected string $name = '';


// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getModule(): AdminModule {
        return $this->module;
    }

    function getParamIdentifier() {
        return $this->paramIdentifier;
    }

    function getValue() {
        return $this->value;
    }

    function getName() {
        return $this->name;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setModule(AdminModule $module) {
        $this->module = $module;
    }

    function setParamIdentifier($paramIdentifier) {
        $this->paramIdentifier = $paramIdentifier;
    }

    function setValue($value) {
        $this->value = $value;
    }

    function setName($name) {
        $this->name = $name;
    }
}

