<?php

namespace IZON\Admin\Config;

use IZON\Admin\Config;
use IZON\Admin\Services\Impl\AdminService;
use IZON\Admin\Services\Impl\LoggedAdminUserSessionService;
use IZON\Admin\Web\Controllers\DashboardController;
use IZON\Admin\Web\Controllers\LoginController;
use IZON\Admin\Web\Controllers\LogoutController;
use IZON\Admin\Web\Controllers\NotificationsController;
use IZON\Admin\Web\Controllers\SwitchCountryController;
use IZON\Admin\Web\Controllers\SwitchInterfaceLocaleController;
use IZON\Admin\Web\Interceptors\HandleLoggedUserInterfaceLocaleInterceptor;
use IZON\Admin\Web\Interceptors\HeaderLinkInterceptor;
use IZON\Admin\Web\Interceptors\LoadAdminVersionInterceptor;
use IZON\Admin\Web\Interceptors\LoadMaxFileSizeInterceprtor;
use IZON\Admin\Web\Interceptors\LoggedUserCheckInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserModulesInterceptor;
use IZON\Admin\Web\Interceptors\SupportedCountriesInterceptor;
use function IZON\Admin\DI\modulesDirs;
use function IZON\DI\create;
use function IZON\DI\get;

return [

    Config::ADMIN_SERVICE_IDENTIFIER => create(AdminService::class)
        ->constructor(get(Config::DEFAULT_DB_ENTITY_MANAGER_IDENTIFIER))
        ->method("setSupportedInterfaceLocaleIdes", get('locale.admin.supportedAdminInterfaceLocaleIdes')),

    // TODO: umoznit jeho prepsani v configu
    'izon.admin.service.adminSessionService' => create(LoggedAdminUserSessionService::class)
        ->constructor(
            get(Config::DEFAULT_DB_ENTITY_MANAGER_IDENTIFIER),
            get(Config::ADMIN_SERVICE_IDENTIFIER),
            get(Config::CONFIG_DIR_IDENTIFIER),
            get("admin.modulesActions"),
            modulesDirs(),
            get('locale.gettextManager')
        )
        ->method('setUniversalPasswordHash', get('admin.universalPasswordHash'))
        ->method("setRoleSupportedCountries", get('admin.roleSupportedCountries')),
    'admin.roleSupportedCountries' => [],

    //// controllery pro admin
    // controller pro prihlaseni a odhlaseni
    Config::LOGIN_CONTROLLER_IDENTIFIER => create(LoginController::class)
        ->constructor(
            get('izon.admin.service.adminSessionService'),
            Config::DASHBOARD_CONTROLLER_IDENTIFIER
        ),

    // controller pro uvodku adminu
    Config::DASHBOARD_CONTROLLER_IDENTIFIER => create(DashboardController::class)
        ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),

    // controller pro odhlaseni z admina
    Config::LOGOUT_CONTROLLER_IDENTIFIER => create(LogoutController::class)
        ->constructor(
            get('izon.admin.service.adminSessionService'),
            Config::LOGIN_CONTROLLER_IDENTIFIER
        ),

    // controller pro zmenu jazyka
    Config::SWITCH_COUNTRY_CONTROLLER_IDENTIFIER => create(SwitchCountryController::class)
        ->constructor(
            get('izon.admin.service.adminSessionService'),
            Config::DASHBOARD_CONTROLLER_IDENTIFIER
        ),

    // controller pro zmenu jazyka
    Config::SWITCH_INTERFACE_LOCALE_CONTROLLER_IDENTIFIER => create(SwitchInterfaceLocaleController::class)
        ->constructor(
            get('izon.admin.service.adminSessionService'),
            Config::DASHBOARD_CONTROLLER_IDENTIFIER
        ),

    // controller pro spravu notifikaci
    Config::NOTIFICATIONS_CONTROLLER_IDENTIFIER => create(NotificationsController::class)
        ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),


    //// interceptory pro admin
    // interceptor pro kontrolu prihlaseneho uzivatele
    Config::LOGGED_USER_CHECK_INTERCEPTOR_IDENTIFIER => create(LoggedUserCheckInterceptor::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    Config::ADMIN_HEADER_LINK_INTERCEPTOR_IDENTIFIER => create(HeaderLinkInterceptor::class)
        ->constructor(get('izon.admin.headerLinks')),

    // interceptor pro nacteni prihlaseneho uzivatele
    Config::HANDLE_LOGGED_USER_INTERFACE_LOCALE_INTERCEPTOR => create(HandleLoggedUserInterfaceLocaleInterceptor::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    // interceptor pro nacteni prihlaseneho uzivatele
    Config::LOGGED_USER_INTERCEPTOR_IDENTIFIER => create(LoggedUserInterceptor::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    // interceptor pro nacteni akci admina
    Config::MODULES_ACTIONS_INTERCEPTOR_IDENTIFIER => create(LoggedUserModulesInterceptor::class)
        ->constructor(
            get('izon.admin.service.adminSessionService'),
            get('admin.modulesActions')
        ),

    // interceptor pro nacteni akci admina
    Config::MODULES_SUPPORTED_COUNTRIES_INTERCEPTOR_IDENTIFIER => create(SupportedCountriesInterceptor::class)
        ->constructor(get('izon.admin.service.adminSessionService')),

    // nacte verzi admina
    Config::ADMIN_VERSION_INTERCEPTOR_IDENTIFIER => create(LoadAdminVersionInterceptor::class)
        ->constructor(get(Config::ADMIN_SERVICE_IDENTIFIER)),

    //nacte max file size
    Config::ADMIN_MAX_FILE_SIZE_INTERCEPTOR_IDENTIFIER => create(LoadMaxFileSizeInterceprtor::class),

];
