<?php
namespace IZON\Admin\Services;

use IZON\DBLocale\Domain\DBCountry;
use IZON\DBLocale\Domain\DBLocale;

use IZON\Admin\Domain\AdminModule;
use IZON\Admin\Domain\AdminModuleSetting;


/**
 * servis, ktery vraci informace o modulech
 */
interface AdminServiceInterface {    
    
    /**
     * returns all active modules
     * @return AdminModule[]
     */
    function getActiveModules();
    
    /**
     * @delpracred this method was moved to IZON\Admin\Services\SessionService
     * returns all modules for logged admin user
     * TODO: is kept here only for partial backward compatibility, instead of user modules returns empty array
     */
    function getLoggedUserModules();
    
    /**
     * vrati vsechny podporovane zeme pro soucasny admin
     * @return DBCountry[]
     */
    function getSupportedCountries();

    /**
     * returns all supported locales for interface of admin
     * @return DBLocale[] Description 
     */
    function getSupportedInterfaceLocales();

    /**
     * @param string $moduleIdentifier
     * @param string $parameterIdentifier
     * @return AdminModuleSetting nastaveni modulu
     * 
     */
    function getModuleSetting($moduleIdentifier, $parameterIdentifier);
    
    /**
     * @param string $moduleIdentifier
     * @return AdminModuleSetting[] AdminModuleSetting nastaveni modulu
     * 
     */
    function getModuleSettings($moduleIdentifier);
    
    /**
     * vrati verzi admina
     * @return string
     */
    function getAdminVersion();
}