<?php

namespace IZON\Admin\Repository;


use IZON\Admin\Domain\AdminModule;


class AdminModuleEntityRepository extends \IZON\DB\Repository\BaseRepository {
    
    public function findAdminVisibleModules(): \Doctrine\ORM\Query {
        return $this->getEntityManager()->createQuery("
            SELECT m FROM ". AdminModule::class ." m WHERE m.active = true AND m.adminVisible = true ORDER BY m.moduleOrder ASC
        ");
    }

    public function findUserAdminVisibleModules($userId): \Doctrine\ORM\Query {
        $queryString = "
            SELECT m FROM ". AdminModule::class ." m
                JOIN m.roles r
                JOIN r.users u
            WHERE m.active = true 
                AND m.adminVisible = true 
                AND u.id = :userId
            ORDER BY m.moduleOrder ASC
        ";
        return $this->getEntityManager()->createQuery($queryString);
    }

}

