<?php

namespace IZON\Admin\Domain;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\JoinColumn;
use Doctrine\ORM\Mapping\JoinTable;
use Doctrine\ORM\Mapping\ManyToMany;
use Doctrine\ORM\Mapping\Table;

/**
 * User role in administration
 * 
 * @Entity
 * @Table(name="core_admin_roles")
 */
#[ORM\Entity]
#[ORM\Table(name: "core_admin_roles")]
class AdminRole {

    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id = null;

    /**
     * @Column
     * @var string
     */
    #[ORM\Column]
    protected string $name = '';

    /**
     * @Column
     * @var string
     */
    #[ORM\Column]
    protected string $description = '';

    /**
     * @var AdminUser[]
     */
    #[ORM\ManyToMany(targetEntity: AdminUser::class, inversedBy: "roles")]
    #[ORM\JoinTable(name: "core_admin_users_admin_roles")]
    #[ORM\JoinColumn(name: "fk_admin_role_id", referencedColumnName: "id")]
    #[ORM\InverseJoinColumn(name: "fk_admin_user_id", referencedColumnName: "id")]
    protected $users;
    
    /**
     * @var AdminModule[] 
     */
    #[ORM\ManyToMany(targetEntity: AdminModule::class, inversedBy: "roles")]
    #[ORM\JoinTable(name: "core_admin_roles_admin_modules")]
    #[ORM\JoinColumn(name: "fk_admin_module_id", referencedColumnName: "id")]
    #[ORM\InverseJoinColumn(name: "fk_admin_role_id", referencedColumnName: "id")]
    protected $modules;
    
    
    public function __construct() {
        $this->users = new ArrayCollection();
        $this->modules = new ArrayCollection();
    }
    
    
/// generated getters and setters    
    function getId() {
        return $this->id;
    }

    function getName() {
        return $this->name;
    }

    function getDescription() {
        return $this->description;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setDescription($description) {
        $this->description = $description;
    }
    
    function getModules() {
        return $this->modules;
    }

    function setModules(array $modules) {
        $this->modules = $modules;
    }
}
