<?php

namespace IZON\Admin\DI\Definition;

use DI\Scope;

use DI\Definition\Definition;

/**
 * definice pro ziskani vsech konfiguraci modulu
 */
class ModuleConfigsDefinition implements Definition
{
    /**
     * Entry name
     * @var string
     */
    private $name;
    
    protected $moduleIdentifier;
    
    
    function __construct($name, $moduleIdentifier) {
        $this->name = $name;
        $this->moduleIdentifier = $moduleIdentifier;
    }

    
    /**
     * @return string Entry name
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getScope() {
        return Scope::SINGLETON;
    }

    function getModuleIdentifier() {
        return $this->moduleIdentifier;
    }

    public function setName(string $name) {
        $this->name = $name;
    }

    public function replaceNestedDefinitions(callable $replacer) {
        // no nested definitions
    }

    public function __toString() {
        return $this->moduleIdentifier .'#'. $this->name;
    }
}
