<?php

namespace IZON\Admin\DI\Definition\Helper;

use DI\Definition\ArrayDefinitionExtension;
use DI\Definition\Helper\DefinitionHelper;
use IZON\Admin\DI\Definition\ModuleConfigDefinition;

/**
 * Helps load module configuration
 */
class ModuleConfigDefinitionHelper implements DefinitionHelper {

    /**
     * @var string identifikator modulu pod kterym se nachazi
     */
    protected $moduleIdentifier;
    
    /**
     * @var string indentifikator parametru pod kterym se hodnota parametru nachazi
     */
    protected $paramIdentifier;

    /**
     * @param array $values Values to add to the array.
     */
    public function __construct($moduleIdentifier, $paramIdentifier) {
        $this->moduleIdentifier = $moduleIdentifier;
        $this->paramIdentifier = $paramIdentifier;
    }

    /**
     * @param string $entryName Container entry name
     */
    public function getDefinition($entryName): \DI\Definition\Definition {
        return new ModuleConfigDefinition($entryName,
                                            $this->moduleIdentifier,
                                            $this->paramIdentifier);
    }

}
