<?php

namespace IZON\Admin\Domain;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use IZON\Admin\Repository\AdminModuleEntityRepository;

/**
 * represents admin module
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 */
#[ORM\Entity(repositoryClass: AdminModuleEntityRepository::class)]
#[ORM\Table(name: "core_admin_modules")]
class AdminModule {

    #[ORM\Id]
    #[ORM\Column]
    #[ORM\GeneratedValue]
    protected ?int $id;

    #[ORM\Column]
    protected string $type;

    /**
     * @var string unique identifier of module
     */
    #[ORM\Column]
    protected string $identifier;

    /**
     * @var string
     */
    #[ORM\Column]
    protected string $name = '';

    /**
     * @var bool
     */
    #[ORM\Column]
    protected bool $active = true;

    /**
     * @var bool if to shown in administration
     */
    #[ORM\Column]
    protected bool $adminVisible = false;

    /**
     * @var bool if only accessable to superuser
     */
    #[ORM\Column]
    protected bool $superuserOnly = false;

    /**
     * @var int how to order modules in menu
     */
    #[ORM\Column]
    protected int $moduleOrder;

    /**
     * @var string icons of module
     */
    #[ORM\Column]
    protected string $icon;

    /**
     * @var AdminRole[] role ktere mohou k modulu pristupovat
     */
    #[ORM\ManyToMany(targetEntity: AdminRole::class, inversedBy: "modules")]
    #[ORM\JoinTable(name: "core_admin_roles_admin_modules")]
    #[ORM\JoinColumn(name: "fk_admin_module_id", referencedColumnName: "id")]
    #[ORM\InverseJoinColumn(name: "fk_admin_role_id", referencedColumnName: "id")]
    protected $roles;

    /**
     * @var AdminModuleSetting[] nastaveni pro modul
     */
    #[ORM\OneToMany(targetEntity: AdminModuleSetting::class, mappedBy: "module", orphanRemoval: true)]
    protected $moduleSettings;


    function __construct() {
        $this->roles = new ArrayCollection();
        $this->moduleSettings = new ArrayCollection();
    }

//// generated getters and setters
    function getId() {
        return $this->id;
    }

    function getType() {
        return $this->type;
    }

    function getIdentifier() {
        return $this->identifier;
    }

    function getName() {
        return $this->name;
    }

    function getEnabled() {
        return $this->enabled;
    }

    function getModuleOrder() {
        return $this->moduleOrder;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setType($type) {
        $this->type = $type;
    }

    function setIdentifier($identifier) {
        $this->identifier = $identifier;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setEnabled($enabled) {
        $this->enabled = $enabled;
    }

    function setModuleOrder($moduleOrder) {
        $this->moduleOrder = $moduleOrder;
    }

    function getIcon() {
        return $this->icon;
    }

    function setIcon($icon) {
        $this->icon = $icon;
    }

    function getAdminVisible() {
        return $this->adminVisible;
    }

    function setAdminVisible($adminVisible) {
        $this->adminVisible = $adminVisible;
    }

    function getRoles() {
        return $this->roles;
    }

    function setRoles($roles) {
        $this->roles = $roles;
    }

    function getModuleSettings() {
        return $this->moduleSettings;
    }

    function setModuleSettings($moduleSettings) {
        $this->moduleSettings = $moduleSettings;
    }

    public function getActive() {
        return $this->active;
    }

    public function getSuperuserOnly() {
        return $this->superuserOnly;
    }

    public function setActive($active) {
        $this->active = $active;
        return $this;
    }

    public function setSuperuserOnly($superuserOnly) {
        $this->superuserOnly = $superuserOnly;
        return $this;
    }

}

