<?php

namespace IZON\Admin\Web\Controllers;

use \IZON\Admin\Services\LoggedAdminUserSessionServiceInterface;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * 
 */
class LogoutController implements Controller {
    
    /**
     * @var LoggedAdminUserSessionServiceInterface
     */
    protected $sessionService;
    
    /**
     * defaultni controller na ktery sa ma po loginu presmerovat
     * @var string|null
     */
    protected $redirectCotrollerIdentifier = NULL;

    
    public function __construct(LoggedAdminUserSessionServiceInterface $sessionService,
                                $redirectCotrollerIdentifier) {
        $this->sessionService = $sessionService;
        $this->redirectCotrollerIdentifier = $redirectCotrollerIdentifier;
    }
    
    public function logout(HttpRequest $request) {
        $this->sessionService->logoutUser();
        $modelAndView = new ModelAndView($this->redirectCotrollerIdentifier, [], true);
        return $modelAndView;
    }
}
