<?php

/*
 * pomocne funkce pro zobrazovani informaci v adminu
 */
namespace AdminPHPView;

use \IZON\Admin\Config;
use \IZON\MVC\Views\PHPView;
use \IZON\Admin\MVC\ModuleInfo;


/**
 * all styles that have to be loaded to admin
 * @return array[]
 */
function getStylesAutoloadURLs() {
    /** @var \IZON\Admin\MVC\Views\AdminPHPView $view */
    $view = PHPView::getApplicationView();
    return $view->getStylesAutoloadURLs();
}

/**
 * all scripts that have to be loaded to admin
 * @return array[]
 */
function getScriptsAutoloadURLs() {
    /** @var \IZON\Admin\MVC\Views\AdminPHPView $view */
    $view = PHPView::getApplicationView();
    return $view->getScriptsAutoloadURLs();
}


/**
 *
 * @param string $moduleControllerId jaky controller volat
 * @param string $action jakou akci controlleru volat
 * @param array $params dalsi parametry, ktere predavat
 * @param string $moduleIdentifier jaky modul volat
 * @return string url pomoci ktereho se zavola dany controller
 *
 * TODO: vyresit, aby se nemuselo zadavat $moduleIdentifier pro odkaz do stejneho modulu
 */
function getModuleActionURL($moduleControllerId, $methodName, $params = [], $moduleIdentifier = NULL) {
    if(empty($moduleIdentifier)) {
        /* @var $activeModule ModuleInfo */
        $activeModule = \PHPView\getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
        $moduleIdentifier = $activeModule->getIdentifier();
    }
    $controllerId = Config::getModuleEntryName($moduleControllerId, $moduleIdentifier);
    $params["action"] = $methodName;

    $view = PHPView::getApplicationView();
    $locale = $view->getLocale();
    // TODO: predavat dovnitr
    $methodName = NULL;
    return $view->getRouter()->findURL($controllerId, $params, $methodName, $locale);
}


/**
 * Vykresli nazev modulu a jeho pripadne akce
 * TODO: sladit s novym zpracovanim menu
 * @param string $title
 */
function renderModuleTitle($title = NULL) {
    $modulesInfos = \PHPView\getParameter("modulesActions");
    $activeModule = \PHPView\getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
    $activeMoludeActions = $modulesInfos[$activeModule->getIdentifier()]['actions'];

    $moduleName = $activeModule->getName();

    if(!empty($activeMoludeActions) && is_array($activeMoludeActions)) {
        foreach($activeMoludeActions as $key => $action) {
            if($action['controllerId'] == $activeModule->getControllerId()) {
                if($action['name'] != $moduleName) {
                    $moduleName .= ': ' . $action['name'];
                }
            }
        }
    }
    echo '<div class="col-xs-12">
         <h1>' . $moduleName . (!is_null($title) ? '<i class="fas fa-caret-right"></i><span class="light">' . $title . '</span>' : '') . '</h1>' .
    '</div>';
}

/**
 * Generate a href to change property of
 * @param $thisModule
 * @param \IZON\DB\DBObject $obj
 * @param $propertyName
 * @return string
 * @throws \Exception
 */
function getPropetryCodeToChange($thisModule, $obj, $propertyName) {
    $propertyName = ucfirst($propertyName);
    $class = 'false';
    $getMethod = 'get' . $propertyName;
    $isMethod = 'is' . $propertyName;
    $method = null;
    if(method_exists($obj, $getMethod)) {
        $method = $getMethod;
    } else if(method_exists($obj, $isMethod)) {
        $method = $isMethod;
    } else {
        throw new \Exception('Class: ' . get_class($obj) . ' is not have method ' . $isMethod . ' or ' . $getMethod);
    }

    if($obj->$method()) {
        $class = 'true';
    }

    $url = getModuleActionURL($thisModule->getControllerId(), 'changeProperty', ["id" => $obj->getId(), 'propertyName' => $propertyName], $thisModule->getIdentifier());

    return '<a class="' . $class . '" href="' . $url . '"><svg class="'.$class.' svg-inline-fa fa-w-20"><use xlink:href="#icon--'.($obj->$method()?'true':'false').'"></use></svg></a>';
}

/**
 * Pro zadane pole vrati do hlavicky kody pro nacteni dodacetcnych css a js
 * 
 * array(src => [nazev lokalniho souboru|komplet adersa na externi zdroj],<br>
 *       type => [css|js], <br>
 *       external => [true|false],<br>
 *       media => typ media pro css, default "all")<br>
 *
 * @param array $additional
 * @return string
 */
//function adminLoadScripts($additional) {
//    $basePath = getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER)->getType() . '/static/';
//    $buff = '';
//    if(!empty($additional) && is_array($additional)) {
//        foreach($additional as $key => $value) {
//            if(empty($value))
//                continue;
//            if($value['external']) {
//                if($value['type'] == 'js')
//                    $buff .= '<script type="text/javascript" src="' . $value['src'] . '"></script>' . LF;
//                elseif($value['type'] == 'css')
//                    $buff .= '<link  href="' . $value['src'] . '" rel="stylesheet" type="text/css" media="' . ($value['media'] != '' ? $value['media'] : 'all') . '" />' . LF;
//            } else {
//                $filePath = $basePath . $value['type'] . '/' . $value['src'] . '.' . $value['type'];
//                if(!file_exists(__BASE_DIR__ . '/admin/vendor/' . $filePath))
//                    continue;
//                #
//                $filePath = '/admin/modules/' . $filePath . '?' . time();
//                if($value['type'] == 'js')
//                    $buff .= '<script type="text/javascript" src="' . $filePath . '"></script>' . LF;
//                elseif($value['type'] == 'css')
//                    $buff .= '<link href="' . $filePath . '" rel="stylesheet" type="text/css" media="' . ($value['media'] != '' ? $value['media'] : 'all') . '" />' . LF;
//            }
//        }
//    }
//    return $buff;
//}

/**
 * nacte pro modul css a js ulozena v adresari static/[css|js]
 * nejde do podadresaru.
 * 
 * @return string
 */
function adminLoadModuleScripts() {
    $buff = '';
    $module = getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
    if($module instanceof ModuleInfo) {
        $basePath = $module->getType() . '/static/';

        $_basePath = __BASE_DIR__ . '/vendor/' . $basePath;
        if(is_dir($_basePath . 'css/')) {
            foreach(scandir($_basePath . 'css/') as $file) {

                if(in_array($file, array('.', '..')) || !IZON\String\endsWith($file, '.css'))
                    continue;
                $filePath = '/admin/modules/' . $basePath . 'css/' . $file . '?' . time();
                $buff .= '<link href="' . $filePath . '" rel="stylesheet" type="text/css" media="all" />' . LF;
            }
        }
        if(is_dir($_basePath . 'js/')) {
            foreach(scandir($_basePath . 'js/') as $file) {
                if(in_array($file, array('.', '..')) || !IZON\String\endsWith($file, '.js'))
                    continue;
                $filePath = '/admin/modules/' . $basePath . 'js/' . $file . '?' . time();
                $buff .= '<script type="text/javascript" src="' . $filePath . '"></script>' . LF;
            }
        }
    }
    return $buff;
}
