<?php

namespace IZON\Admin\Domain\Interfaces;

use Doctrine\Common\Collections\Collection;
use IZON\Admin\Domain\AdminRole;
use IZON\DBLocale\Domain\DBCountry;
use IZON\DBLocale\Domain\DBLocale;

interface AdminUserInterface {

    /**
     * @return AdminRole[]|iterable|Collection
     */
    public function getRoles(): iterable;

    /**
     * @param AdminRole[]|iterable|Collection $roles
     */
    public function setRoles(iterable $roles): void;

    /**
     * @param AdminRole $role
     */
    public function addRole(AdminRole $role): void;

    /**
     * @param AdminRole $role
     * @return bool
     */
    public function hasRoleByRole(AdminRole $role): bool;

    /**
     * overi, jestli ma prihlazeny uzivatel zadanou roli
     * pro sureusera vzdy vraci true
     * @param int|array $roleId
     * @return boolean
     */
    public function hasRoleByRoleId($roleId): bool;

    public function getId(): ?int;

    public function getFirstName(): ?string;

    public function getLastName(): ?string;

    public function getLogin(): ?string;

    public function getPassword(): ?string;

    public function getActive(): bool;

    public function getSuperuser(): bool;

    public function getInterfaceLocale(): DBLocale;

    public function setId(?int $id): void;

    public function setFirstName(string $firstName): void;

    public function setLastName(string $lastName): void;

    public function setLogin(string $login): void;

    public function setPassword(string $password): void;

    public function setActive(bool $active): void;

    public function setSuperuser(bool $superuser): void;

    public function setInterfaceLocale(DBLocale $interfaceLocale): void;

    public function getCountry(): DBCountry;

    public function setCountry(DBCountry $country);
}
