<?php
namespace IZON\Admin\Services\Impl;

use IZON\Admin\Domain\AdminModule;
use IZON\Admin\Domain\AdminModuleSetting;
use IZON\Admin\Services\AdminServiceInterface;
use IZON\DB\EntityManagerInterface;
use IZON\DB\Repository\BaseRepository;
use IZON\DBLocale\Domain\DBCountry;
use IZON\DBLocale\Domain\DBLocale;

class AdminService implements AdminServiceInterface {

    /**
     * @var AdminModuleEntityRepository
     */
    protected $adminModuleRepsitory;

    /**
     * @var BaseRepository
     */
    protected $localeRepsitory;

    /**
     * @var BaseRepository
     */
    protected $coutryRepsitory;

    /**
     * @var BaseRepository
     */
    protected $adminModuleSettingRepository;

    /**
     * @var array
     */
    protected $supportedInterfaceLocaleIdes;


    public function __construct(EntityManagerInterface $entityManager) {
        $this->adminModuleRepsitory = $entityManager->getRepository(AdminModule::class);
        $this->adminModuleSettingRepository = $entityManager->getRepository(AdminModuleSetting::class);
        $this->localeRepsitory = $entityManager->getRepository(DBLocale::class);
        $this->coutryRepsitory = $entityManager->getRepository(DBCountry::class);
    }

    /**
     * {@inheritdoc}
     */
    function getActiveModules() {
        return $this->adminModuleRepsitory->findBy(['active' => true]);
    }

    function getLoggedUserModules() {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public function getModuleSetting($moduleIdentifier, $parameterIdentifier) {
        /* @var $module AdminModule */
        $module = $this->adminModuleRepsitory->findOneBy(["identifier" => $moduleIdentifier]);
        /* @var $moduleSettings AdminModuleSetting */
        $moduleSettings =  $this->adminModuleSettingRepository->findOneBy(["module" => $module, "paramIdentifier" => $parameterIdentifier]);
        return $moduleSettings;
    }

    /**
     * {@inheritdoc}
     */
    public function getModuleSettings($moduleIdentifier) {
        /* @var $module AdminModule */
        $module = $this->adminModuleRepsitory->findOneBy(["identifier" => $moduleIdentifier]);
        return $module->getModuleSettings();
    }

    /**
     * {@inheritdoc}
     */
    public function getSupportedCountries() {
        return $this->coutryRepsitory->findAll();
    }

    /**
     * {@inheritdoc}
     */
    public function getSupportedInterfaceLocales() {
        $supportedInterfaceLocales = [];
        foreach($this->supportedInterfaceLocaleIdes as $supportedInterfaceLocaleId) {
            /* @var $locale DBLocale */
            $locale = $this->localeRepsitory->find($supportedInterfaceLocaleId);
            $supportedInterfaceLocales[] = $locale;
        }
        return $supportedInterfaceLocales;
    }

    /**
     * {@inheritdoc}
     */
    public function getAdminVersion() {
        $version = json_decode(file_get_contents(__DIR__ .'/../../../../../composer.json'), true)['version'];
        return $version;
    }

    /**
     * {@inheritdoc}
     */
    function setSupportedInterfaceLocaleIdes(array $supportedInterfaceLocaleIdes = [1]) {
        $this->supportedInterfaceLocaleIdes = $supportedInterfaceLocaleIdes;
    }
}
