<?php

namespace IZON\Admin\Presentation\Domain;

/**
 * HeaderLink
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
class HeaderLink {
    /**
     * @var string
     */
    protected $controllerUid = '';
    /**
     * @var array
     */
    protected $params = [];
    /**
     * @var string
     */
    protected $title = '';
    /**
     * @var string
     */
    protected $domainUID = '';
    /**
     * @var string
     */
    protected $localeTag = '';

    public function __construct($controllerUid, $params, $title, $domainUID, $localeTag) {
        $this->controllerUid = $controllerUid;
        $this->params = $params;
        $this->title = $title;
        $this->domainUID = $domainUID;
        $this->localeTag = $localeTag;
    }

    public function getControllerUid() {
        return $this->controllerUid;
    }

    public function getParams() {
        return $this->params;
    }

    public function setControllerUid($controllerUid) {
        $this->controllerUid = $controllerUid;
    }

    public function setParams($params) {
        $this->params = $params;
    }

    /**
     * @return string
     */
    public function getTitle(): string {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title): void {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getDomainUID(): string {
        return $this->domainUID;
    }

    /**
     * @param string $domainUID
     */
    public function setDomainUID(string $domainUID): void {
        $this->domainUID = $domainUID;
    }

    /**
     * @return string
     */
    public function getLocaleTag(): string {
        return $this->localeTag;
    }

    /**
     * @param string $localeTag
     */
    public function setLocaleTag(string $localeTag): void {
        $this->localeTag = $localeTag;
    }

    /**
     * Check if link is correctly configured.
     * @return boolean
     */
    public function isSet() {
        return !empty($this->controllerUid) && !empty($this->domainUID) && !empty($this->title);
    }

}
