<?php

namespace IZON\Admin\Repositories;


use Doctrine\ORM\Query;
use IZON\Admin\Domain\AdminModule;
use IZON\DB\Repository\BaseRepository;


class AdminModuleRepository extends BaseRepository {

    public function findAdminVisibleModules(): Query {
        return $this->getEntityManager()->createQuery("
            SELECT m FROM ". AdminModule::class ." m WHERE m.active = true AND m.adminVisible = true ORDER BY m.moduleOrder ASC
        ");
    }

    public function findUserAdminVisibleModules($userId): Query {
        $queryString = "
            SELECT m FROM ". AdminModule::class ." m
                JOIN m.roles r
                JOIN r.users u
            WHERE m.active = true
                AND m.adminVisible = true
                AND u.id = :userId
            ORDER BY m.moduleOrder ASC
        ";
        return $this->getEntityManager()->createQuery($queryString);
    }

}

