<?php

namespace IZON\Admin\Web\Interceptors;

use \IZON\MVC\Interceptors\Interceptor;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

use \IZON\Admin\Services\AdminServiceInterface;

/**
 *  nacte verzi admina
 */
class LoadAdminVersionInterceptor implements Interceptor {
    
    /**
     * @var AdminServiceInterface 
     */
    protected $adminService;

    
    function __construct(AdminServiceInterface $adminService) {
        $this->adminService = $adminService;
    }
    
    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        $adminVersion = $this->adminService->getAdminVersion();
        $model->putParameter("adminVersion", $adminVersion);  
        return $model;
    }

    public function preHandle(HttpRequest $request) {
        
    }

}
