<?php

namespace IZON\Admin\Web\Controllers;

use Exception;
use Throwable;
use IZON\Admin\MVC\Context\AdminContext;
use IZON\Admin\Services\AbstractBaseService;
use IZON\DB\Paginator\PaginatorConfig;
use IZON\DB\Paginator\PaginatorConfigInterface;
use IZON\DB\QueryParams\OrderBy;
use IZON\Forms\Form;
use IZON\Forms\FormInterface;
use IZON\IO\File;
use IZON\IO\Image;
use IZON\MVC\HttpRequest;
use IZON\MVC\Json\JsonResponse;
use IZON\MVC\ModelAndView;


abstract class AbstractBaseController {

    /**
     * @var AbstractBaseService
     */
    protected $service;


    function __construct(AbstractBaseService $service) {
        $this->service = $service;
    }

    /**
     * @deprecated use toggleProperty instead
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function changeProperty(HttpRequest $request) {
        return $this->toggleProperty($request);
    }

    /**
     *
     * @param HttpRequest $request
     * @return ModelAndView
     * @throws Exception
     */
    public function toggleProperty(HttpRequest $request) {
        if($request->hasParameter('propertyName')) {
            $this->service->toggleEntityProperty($request->getParameter('id'), $request->getParameter('propertyName'));
        }

        $mav = ModelAndView::createControllerRedirect($request->getCalledControllerId(), ["action" => "execute"]); // presmerovavat na senam
        return $mav;
    }

    /**
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function ajaxToggleProperty(HttpRequest $request) {
        $mav = new ModelAndView('admin/simple/json-response');

        if( !$request->hasParameter('id')) {
            $mav->putParameter('json', JsonResponse::createErrorResponse('id of entity not provided.'));
            return $mav;
        }
        if( !$request->hasParameter('propertyName')) {
            $mav->putParameter('json', JsonResponse::createErrorResponse('propertyName of entity not provided.'));
            return $mav;
        }

        try {
            $this->service->toggleEntityProperty($request->getParameter('id'), $request->getParameter('propertyName'));
        } catch(\Throwable $exception) {
            $mav->putParameter('json', JsonResponse::createErrorResponse($exception->getMessage()));
            return $mav;
        }

        $mav->putParameter('json', JsonResponse::createResponse([]));
        return $mav;
    }


//    public function ajaxUploadFile(HttpRequest $request) {
//        $id = $request->getParameter("id");
//        if(!$id) {
//            $id = 0;
//        }
//
//        // kde je soubor ulozen
//        $fileURI = $_FILES["file"]["tmp_name"];
//        // ciste jmeno
//        $fileName = File::getSafeFileName($_FILES["file"]["name"]);
//        $fileFolder = uniqid();
//
//        // presun do temporary souboru
//        // TODO: udelat nejak inteligentneji, aby se dano nastavovat
//        $tempFileDir = $this->getFileUploadTempDir() . "/" . $fileFolder;
//        if(!file_exists($tempFileDir)) {
//            // vytvor temporry
//            mkdir($tempFileDir, 0770, true);
//        }
//        $tempFileName = $tempFileDir . "/" . $fileName;
//        move_uploaded_file($fileURI, $tempFileName);
//
//        $mineType = mime_content_type($tempFileName);
//        $dataType = $this->dataTypes[$mineType];
//
//        $retval = ["id" => $fileFolder . "/" . $fileName,
//                   "fileName" => $fileName,
//                   "description" => '',
//                   "fileURL" => $fileFolder . "/" . $fileName,
//                   'mineType' => $mineType,
//                   'dataType' => $dataType
//        ];
//
//        $modelAndView = new ModelAndView("admin/simple/json-response");
//        $modelAndView->putParameter("json", $retval);
//
//        return $modelAndView;
//    }
//
//    protected function getFileUploadTempDir() {
//        return __BASE_DIR__ ."/app-data/tmp/user-data/". session_id() ."/". $this->filesFolder;
//    }
//
//    public function ajaxGetFileContent(HttpRequest $request) {
//        $imgURL = $request->getParameter("imgURL");
//        $file = $this->getFileUploadTempDir() . "/" . $imgURL;
//        $image = new File($file);
//
//        $modelAndView = new ModelAndView("admin/raw-data");
//        $modelAndView->putParameter("contentType", $image->getMineType());
//        $modelAndView->putParameter("data", file_get_contents($file));
//
//        return $modelAndView;
//    }
//
//    /**
//     * smaze obsah adresare kompletne rekurzivne
//     * @param string $dir
//     */
//    protected function deleteRecursivelly($dir = null) {
//        if($dir == null) {
//            $dir = $this->getFileUploadTempDir();
//        }
//        if(!file_exists($dir)) {
//            return;
//        }
//        foreach(scandir($dir) as $subFile) {
//            $absFileDir = $dir . "/" . $subFile;
//
//            if(is_dir($absFileDir)) {
//                if($subFile != "." && $subFile != "..") {
//                    $this->deleteRecursivelly($absFileDir);
//                    rmdir($absFileDir);
//                }
//            } else { // je soubor smazat ho
//                unlink($absFileDir);
//            }
//        }
//    }

    public function ajaxChangeEntitySequenceNumber(HttpRequest $request) {
        $mav = new ModelAndView('admin/simple/json-response');

        if( !$request->hasParameter("id") ) {
            $mav->putParameter('json', JsonResponse::createErrorResponse("Can't change order number. No entity id provided"));
            return $mav;
        }

        if( !$request->hasParameter("sequenceNumber") ) {
            $mav->putParameter('json', JsonResponse::createErrorResponse("Can't change order number. No orderNumber provided"));
            return $mav;
        }

        $id = $request->getParameter("id");
        $sequenceNumber = $request->getParameter("sequenceNumber");
        $propertyName = 'sequenceNumber';
        if( $request->hasParameter("propertyName") ) {
            $propertyName = $request->getParameter("propertyName");
        }

        try {
            $this->service->changeEntitySequenceNumber($id, $sequenceNumber, $propertyName);
        } catch(Throwable $ex) {
            $jsonResponse = JsonResponse::createErrorResponse($ex->getMessage());
            $mav->putParameter("json", $jsonResponse);
            return $mav;
        }

        $jsonResponse = JsonResponse::createResponse([]);
        $mav->putParameter("json", $jsonResponse);
        return $mav;
    }

    /**
     * Vratí pole obrazku které obdrzel v requestu - pouze gallery
     * @param HttpRequest $request
     * @param $class typ tridy obrazku.
     * @return array
     */
    protected function getArrayOfImages(HttpRequest $request, $class) {

        $images = [];

        if($request->hasParameter($this->imagesPrefix)) {
            $fileUploadTempDir = $this->getFileUploadTempDir();
            foreach($request->getParameter($this->imagesPrefix) as $index => $value) {
                $image = new $class();
                $imgForm = $this->createImageForm([$this->imagesPrefix, $index]);
                $imgForm->setValues($request->getParameters());
                $imgForm->flush($image);

                //otoceni
                if(isset($value["turn"]) && $value["turn"] != 0)
                    $image->setTurn($value["turn"]);

                if($image->getId() != 0) { // je updatovany obrazek
                    $images[] = $image;
                } else { // je nove nahravany obrazek
                    $tempFile = $fileUploadTempDir . "/" . $index;
                    if(is_file($tempFile)) {
                        $image->setImage(new Image($tempFile));
                        // TODO: pridat informace o obrazku co se ma vlozit

                        $images[] = $image;
                    }
                }
            }
        }

        return $images;
    }

    /**
     * Vratí pole obrazku které obdrzel v requestu - pouze gallery
     * @param HttpRequest $request
     * @param $class typ tridy obrazku.
     * @return array
     */
    protected function getArrayOfFiles(HttpRequest $request, $class) {

        $files = [];

        if($request->hasParameter($this->filesPrefix)) {
            $fileUploadTempDir = $this->getFileUploadTempDir();
            foreach($request->getParameter($this->filesPrefix) as $index => $value) {
                $file = new $class();
                $fileForm = $this->createFileForm([$this->filesPrefix, $index]);
                $fileForm->setValues($request->getParameters());
                $fileForm->flush($file);

                if($file->getId() != 0) { // je updatovany soubor
                    $files[] = $file;
                } else { // je nove nahravany soubor
                    $tempFile = $fileUploadTempDir . "/" . $index;
                    if(is_file($tempFile)) {
                        $file->setFile(new File($tempFile));
                        // TODO: pridat informace o obrazku co se ma vlozit

                        $files[] = $file;
                    }
                }
            }
        }

        return $files;
    }

    protected function getPhotoFilePath($fileName) {
        return $this->getFileUploadTempDir() . '/' . $fileName;
    }

    /**
     * Pouziva se pouze pro gallerie
     * @param array $prefix
     * @return Form
     */
    protected function createImageForm(array $prefix) {
        $form = new Form($prefix);
        $form->addIdField("id", __("Id"));
        $form->addIntegerField("position");
        $form->addHiddenField("photoFileName");
        $form->addHiddenField("newPhotoFileName");
        $form->addCharField('description');

        return $form;
    }

    /**
     * Pouziva se pouze pro soubory
     * @param array $prefix
     * @return Form
     */
    protected function createFileForm(array $prefix) {
        $form = new Form($prefix);
        $form->addIdField("id", __("Id"));
        $form->addIntegerField("position");
        $form->addCharField("name");
        $form->addHiddenField("newFileName");
        $form->addHiddenField("fileName");
        $form->addCharField('description');
        $form->addHiddenField('dataType')->setOneWay(true);

        return $form;
    }

    /**
     * Is posted opeation update?
     *
     * @param HttpRequest $request
     * @return boolean
     */
    public function _isUpdateOperation(HttpRequest $request) {
        return $request->hasParameter("id") && $request->getParameter("id") + 0 > 0 ? true : false;
    }

    /**
     * Return object
     *
     * @param HttpRequest $request
     * @return object
     */
    public function _getBaseObject(HttpRequest $request) {
        if($this->_isUpdateOperation($request)) {
            $id = $request->getParameter("id");
            $object = $this->service->get($id);
        } else {
            $object = $this->createDomainObject();
        }
        return $object;
    }

    public function ajaxGetCurrentPage(HttpRequest $request, AdminContext $context) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/list/list-content");

        $paginatorConfig = $this->getPaginatorConfig($context);

        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);
        $page = $this->getPage($paginatorConfig);
        $modelAndView->putParameter("pageContent", $page);

        return $modelAndView;
    }

    protected abstract function getPage(PaginatorConfig $config);

    public function ajaxChangeListOrder(HttpRequest $request, AdminContext $context) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/list/list-content");

        if(!$request->hasParameter("propertyName")) {
            throw new Exception("Neni nastaven parametr property");
        }
        $propertyName = $request->getParameter("propertyName");
        $sortingType = $request->getParameter("sortingType");

        $paginatorConfig = $this->getPaginatorConfig($context);

        $paginatorConfig->clearOrders();
        $paginatorConfig->addOrder($propertyName,  $sortingType == 'desc' ? OrderBy::ORDER_DESC : OrderBy::ORDER_ASC);

        $this->saveListOrder($context, $propertyName, $sortingType == 'desc' ? OrderBy::ORDER_DESC : OrderBy::ORDER_ASC);

        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);
        $modelAndView->putParameter("pageContent", $this->getPage($paginatorConfig));

        return $modelAndView;
    }

    public function ajaxSetFilter(HttpRequest $request, AdminContext $context) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/list/list-content");

        $filterForm = $this->createFilterForm();
        $filterForm->setValues($request->getParameters());

        $paginatorConfig = $this->getPaginatorConfig($context);
        $filterForm->flush($paginatorConfig);

        $this->modifyPaginator($paginatorConfig, $filterForm);
        // move to first page
        $paginatorConfig->setFirstResult(0);

        $this->saveFilter($context, $filterForm->getValues());

        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);
        $modelAndView->putParameter("pageContent", $this->getPage($paginatorConfig));

        return $modelAndView;
    }

    protected abstract function modifyPaginator(PaginatorConfig $paginatorConfig, Form $filterForm);

    public function ajaxClearFilter(HttpRequest $request, AdminContext $context) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/list/list-content");

        $this->clearFilter($context);

        $paginatorConfig = $this->getPaginatorConfig($context);
        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);
        $modelAndView->putParameter("pageContent", $this->getPage($paginatorConfig));

        return $modelAndView;
    }

    public function ajaxSwirchPage(HttpRequest $request, AdminContext $context) {
        $modelAndView = new ModelAndView("admin/" . $this->viewName . "/list/list-content");

        if(!$request->hasParameter("pageNumber")) {
            throw new Exception("Neni nastaven parametr property");
        }
        $pageNumber = $request->getParameter("pageNumber");

        $paginatorConfig = $this->getPaginatorConfig($context);
        $firstResult = ($pageNumber - 1) * $paginatorConfig->getPageSize();
        $paginatorConfig->setFirstResult(max(0, $firstResult));
        $this->saveFirstResult($context, $paginatorConfig->getFirstResult());


        $modelAndView->putParameter("paginatorConfig", $paginatorConfig);
        $modelAndView->putParameter("pageContent", $this->getPage($paginatorConfig));

        return $modelAndView;
    }

    protected abstract function getPaginatorSessionIdentifier(): string;

    /**
     *
     * @param AdminContext $context
     * @return PaginatorConfigInterface
     */
    protected function getPaginatorConfig(AdminContext $context): PaginatorConfigInterface {
        $paginatorConfig = $this->createPaginatorConfig();

        $session = $context->getSession();
        $session->lock();

        $paginatorConfigState = $session->getParameter($this->getPaginatorSessionIdentifier() . "-filter");
        if( is_array($paginatorConfigState) ) { // we have filter array
            $filterForm = $this->createFilterForm();
            $filterForm->setValues($paginatorConfigState);
            $filterForm->flush($paginatorConfig);
            $this->modifyPaginator($paginatorConfig, $filterForm);
        }

        $firstResult = $session->getParameter($this->getPaginatorSessionIdentifier() . "-filter-first-result");
        if( !empty($firstResult) ) {
            $paginatorConfig->setFirstResult(max(0, $firstResult));
        }

        $orderName = $session->getParameter($this->getPaginatorSessionIdentifier() . "-filter-order-name");
        $orderType = $session->getParameter($this->getPaginatorSessionIdentifier() . "-filter-order-type");
        if( !empty($orderName) ) {
            $paginatorConfig->clearOrders();
            $paginatorConfig->addOrder($orderName, $orderType);
        }

        $session->unlock();

        return $paginatorConfig;
    }

    protected abstract function createPaginatorConfig(): PaginatorConfigInterface;

    protected function getFilterActive(AdminContext $context) {
        return $context->getSessionParameter($this->getPaginatorSessionIdentifier() . "-filter-active");
    }

    protected function saveFirstResult(AdminContext $context, int $firstResult) {
        $session = $context->getSession();
        $session->lock();
        $session->setParameter($this->getPaginatorSessionIdentifier() . "-filter-first-result", $firstResult);
        $session->unlock();
    }

    protected function saveListOrder(AdminContext $context, string $orderName, string $orderType) {
        $session = $context->getSession();
        $session->lock();
        $session->setParameter($this->getPaginatorSessionIdentifier() . "-filter-order-name", $orderName);
        $session->setParameter($this->getPaginatorSessionIdentifier() . "-filter-order-type", $orderType);
        $session->unlock();
    }

    protected function saveFilter(AdminContext $context, array $formValues) {
        $session = $context->getSession();
        $session->lock();
        $session->setParameter($this->getPaginatorSessionIdentifier() . "-filter", $formValues);
        $session->setParameter($this->getPaginatorSessionIdentifier() . "-filter-first-result", 0);
        $session->setParameter($this->getPaginatorSessionIdentifier() . "-filter-active", true);
        $session->unlock();
    }

    protected function clearFilter(AdminContext $context) {
        $session = $context->getSession();
        $session->lock();
        $session->removeParameter($this->getPaginatorSessionIdentifier() . "-filter");
        $session->removeParameter($this->getPaginatorSessionIdentifier() . "-filter-active");
        $session->removeParameter($this->getPaginatorSessionIdentifier() . "-filter-first-result");
        $session->unlock();
    }

    /**
     * returns filter form with stored state
     * @param AdminContext $context
     * @return FormInterface
     */
    protected function getFilterForm(AdminContext $context): FormInterface {
        $filterForm = $this->createFilterForm();
        $filterState = $context->getSessionParameter($this->getPaginatorSessionIdentifier() . "-filter");
        if( is_array($filterState) ) {
            $filterForm->setValues($filterState);
        }
        return $filterForm;
    }

    protected abstract function createFilterForm(): FormInterface;
}
