<?php

namespace IZON\Admin\Domain;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

use IZON\Admin\DB\AdminModuleEntityRepository;

/**
 * represents admin module
 *
 * @author IZON s.r.o. <info@izon.cz>
 *
 * @ORM\Entity(repositoryClass="\IZON\Admin\Repository\AdminModuleEntityRepository")
 * @ORM\Table(name="core_admin_modules")
 */
class AdminModule {

    /**
     * @ORM\Id()
     * @ORM\Column()
     * @ORM\GeneratedValue()
     * @var int
     */
    protected $id;

    /**
     * @ORM\Column()
     * @var string module type
     */
    protected $type;

    /**
     * @ORM\Column()
     * @var string unique identifier of module
     */
    protected $identifier;

    /**
     * @ORM\Column()
     * @var string
     */
    protected $name;

    /**
     * @ORM\Column()
     * @var bool
     */
    protected $active = true;

    /**
     * @ORM\Column()
     * @var bool if to shown in administration
     */
    protected $adminVisible = false;

    /**
     * @ORM\Column()
     * @var bool if only accessable to superuser
     */
    protected $superuserOnly = false;

    /**
     * @ORM\Column()
     * @var int how to order modules in menu
     */
    protected $moduleOrder;

    /**
     * @ORM\Column()
     * @var string icons of module
     */
    protected $icon;

    /**
     * @ORM\ManyToMany(targetEntity="AdminRole", inversedBy="modules")
     * @ORM\JoinTable(
     *     name="core_admin_roles_admin_modules",
     *     joinColumns={@ORM\JoinColumn(name="fk_admin_module_id", referencedColumnName="id")},
     *     inverseJoinColumns={@ORM\JoinColumn(name="fk_admin_role_id", referencedColumnName="id")}
     * )
     * @var AdminRole[] role ktere mohou k modulu pristupovat
     */
    protected $roles;

    /**
     * @ORM\OneToMany(targetEntity="AdminModuleSetting", mappedBy="module", orphanRemoval=true)
     * @var AdminModuleSetting[] nastaveni pro modul
     */
    protected $moduleSettings;


    function __construct() {
        $this->roles = new ArrayCollection();
        $this->moduleSettings = new ArrayCollection();
    }

//// generated getters and setters
    function getId() {
        return $this->id;
    }

    function getType() {
        return $this->type;
    }

    function getIdentifier() {
        return $this->identifier;
    }

    function getName() {
        return $this->name;
    }

    function getEnabled() {
        return $this->enabled;
    }

    function getModuleOrder() {
        return $this->moduleOrder;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setType($type) {
        $this->type = $type;
    }

    function setIdentifier($identifier) {
        $this->identifier = $identifier;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setEnabled($enabled) {
        $this->enabled = $enabled;
    }

    function setModuleOrder($moduleOrder) {
        $this->moduleOrder = $moduleOrder;
    }

    function getIcon() {
        return $this->icon;
    }

    function setIcon($icon) {
        $this->icon = $icon;
    }

    function getAdminVisible() {
        return $this->adminVisible;
    }

    function setAdminVisible($adminVisible) {
        $this->adminVisible = $adminVisible;
    }

    function getRoles() {
        return $this->roles;
    }

    function setRoles($roles) {
        $this->roles = $roles;
    }

    function getModuleSettings() {
        return $this->moduleSettings;
    }

    function setModuleSettings($moduleSettings) {
        $this->moduleSettings = $moduleSettings;
    }

    public function getActive() {
        return $this->active;
    }

    public function getSuperuserOnly() {
        return $this->superuserOnly;
    }

    public function setActive($active) {
        $this->active = $active;
        return $this;
    }

    public function setSuperuserOnly($superuserOnly) {
        $this->superuserOnly = $superuserOnly;
        return $this;
    }

}

