<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Presentation\Domain\HeaderLink;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;

/**
 * Adds HeaderLink (configured from config) object to view.
 */
class HeaderLinkInterceptor implements Interceptor {

    const AVAILABLE_AS = '_izonAdminHeaderLinks';

    /**
     * @var HeaderLink[]
     */
    protected $headerLinks = [];

    /**
     * HeaderLinkInterceptor constructor.
     * @param array $links
     */
    public function __construct(array $links) {
        $headerLinks = [];
        foreach($links as $link) {
            $headerLink = new HeaderLink(
                $link['controllerUid'],
                $link['params'],
                $link['title'],
                $link['domainUID'],
                $link['localeTag']
            );
            $headerLinks[] = $headerLink;
        }
        $this->headerLinks = $headerLinks;
    }

    public function afterCompletion(HttpRequest $request, $exception) {

    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        $model->putParameter(self::AVAILABLE_AS, $this->headerLinks);
    }

    public function preHandle(HttpRequest $request) {

    }

}
