<?php

namespace IZON\Admin\Presentation\Domain;

use Exception;

/**
 * action of module
 */
class AdminModuleActionInfo {
    
    /**
     * @var string 
     */
    protected $name;

    /**
     * @var string 
     */
    protected $actionIdentifier;

    /**
     * @var string 
     */
    protected $controllerIdentifier;

    /**
     * @var string
     */
    protected $methodName;

    /**
     * @var array
     */
    protected $parameters = [];
    
    /**
     * @var string identifier of action this action was called from 
     */
    protected $parentActionIdentifier = null;
    
    /**
     * @var boolean true if this is currently shown action 
     */
    protected $currentAction = false;

    /**
     *
     * @var boolean true if this parent of some currently shown action 
     */
    protected $parentAction = false;

/// generated constuctor
    function __construct($name, $actionIdentifier, $controllerIdentifier, $methodName) {
        $this->name = $name;
        $this->actionIdentifier = $actionIdentifier;
        $this->controllerIdentifier = $controllerIdentifier;
        $this->methodName = $methodName;
    }

    function isCurrentAction() {
        return $this->currentAction;
    }

    function setCurrentAction($currentAction) {
        $this->currentAction = $currentAction;
    }
    
    function isParentAction() {
        return $this->parentAction;
    }

    function setParentAction($parentAction) {
        $this->parentAction = $parentAction;
    }
    
    function getActionIdentifier() {
        return $this->actionIdentifier;
    }
    
/// generated getters and setters
    function getName() {
        return $this->name;
    }

    function getControllerIdentifier() {
        return $this->controllerIdentifier;
    }

    function getMethodName() {
        return $this->methodName;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setControllerIdentifier($controllerIdentifier) {
        $this->controllerIdentifier = $controllerIdentifier;
    }

    function setMethodName($methodName) {
        $this->methodName = $methodName;
    }
    
    function getParameters() {
        return $this->parameters;
    }

    function setParameters(array $parameters) {
        $this->parameters = $parameters;
    }
    
    function getParentActionIdentifier() {
        return $this->parentActionIdentifier;
    }

    function setParentActionIdentifier($parentActionIdentifier) {
        $this->parentActionIdentifier = $parentActionIdentifier;
    }
}
