/**
 * table that handles filtering, sorting and paging
 */
$.widget( "izon.dynamicTable", {
    
    /**
     * cells that can change order of page
     */
    _sortableColumnsHeaderCells: null,
    
    /**
     * element that contains table data rows
     */
    _tableBodyContainer: null,
    
    /**
     * form that can filter imput
     */
    _filterForm: null,
    
    /**
     * elements to switch pages of table
     */
    _pageSwitchers: null,

    /**
     * index of last request sent to server
     */
    _lastRequestIndex: 0,

    /**
     * timeout callback function for filter data reloading
     */
    _filterReloadTimeout: null,

    /**
     * how long to wait til send request for page reloading when filter changed
     */
    _filterReloadDelay: null,

    /**
     * elements to clear filter
     */
    _clearFilterClickables: null,
    
    
    options: {
        currentPage: 1,
        pagesCount: 0,
        
        // default row rendered, only renders all walues passed in rowData object
        rowRenderer: function(rowData) {
            var row = "<tr>";
            for (var i = 0; rowData.length(); i++) {
                var cellData = rowData[i];
                row += "<td>" + cellData.value + "</td>";
            }
            row += "</tr>";
            return row;
        },
        filterFormSelector: "#dynamic-table-filter",
        clearFilterClickablesSelector: "#dynamic-table-filter .js-clear-filter",
        filterReloadDelay: 200,
        pageSwitchersSelector: ".page-switcher",
        noRowsFoundMessage: "Nebyl nalezen žádný záznam.",
        loadingMessage: 'Vykresluji obsah tabulky'
    },

    // construcor of widget
    _create: function() {
        var _thisWidget = this;

        this._tableBodyContainer = this.element.find("tbody");

        this._sortableColumnsHeaderCells = this.element.find("thead th.sortable[data-property-name]");
        this._sortableColumnsHeaderCells.append('<span class="sortable__down"></span><span class="sortable__up"></span>');
        // change order type
        this._sortableColumnsHeaderCells.click(function(event, data) {
            var sortByName = $(this).data("property-name");
            var sortingType = _thisWidget._getSortingType($(this));
            _thisWidget.sortBy(sortByName, sortingType);
        });

        this._filterReloadDelay = this.options.filterReloadDelay;

        // find page switchers
        if(typeof this.options.filterForm != 'undefined') { // passed in options
            this._filterForm = this.options.filterForm;
        } else {
            this._filterForm = $(this.options.filterFormSelector);
        }
        this._filterForm.submit(function(event) {
            event.preventDefault();
            _thisWidget._loading();
            var formData = $(this).serializeArray();
            $.getJSON(_thisWidget.options.setFilterURL, formData, function(data) {
                _thisWidget._updateData(data);
            });
        });
        
        if( typeof this.options.clearFilter != 'undefined' ) { // passed in options
            this._clearFilterClickables = this.options.clearFilterClickables;
        } else {
            this._clearFilterClickables = $(this.options.clearFilterClickablesSelector);
        }
        
        this._clearFilterClickables.click(function(event) {
            event.preventDefault();
            $.getJSON(_thisWidget.options.clearFilterURL, function(data) {
                location.reload();
            });
        });
        
        // find and handle page switchers
        if(typeof this.options.pageSwitchers != 'undefined') { // passed in options
            this._pageSwitchers = this.options.pageSwitchers;
        } else {
            this._pageSwitchers = $(this.options.pageSwitchersSelector);
        }
        this._pageSwitchers.find(".page-switcher__input").change(function(event) {
            var selectedPage = $(this).val();
            _thisWidget.switchPage(selectedPage);
        });
        this._pageSwitchers.find(".page-switcher__prev").click(function(event) {
            var prevPageNumber = parseInt(_thisWidget._pageSwitchers.find(".page-switcher__input").val()) - 1;
            if(prevPageNumber >= 1) {
                _thisWidget.switchPage(prevPageNumber);
            }

        });
        this._pageSwitchers.find(".page-switcher__next").click(function(event) {
            var nextPageNumber = parseInt(_thisWidget._pageSwitchers.find(".page-switcher__input").val()) + 1;
            var pagesCount = parseInt(_thisWidget._pageSwitchers.find(".page-switcher__input").attr("max"));
            if(nextPageNumber <= pagesCount) {
                _thisWidget.switchPage(nextPageNumber);
            }
        });

        this.reload();
    },

    sortBy: function(propertyName, sortingType) {
        var _thisWidget = this;
        _thisWidget._loading();
        var thisRequestIndex = ++_thisWidget._lastRequestIndex;
        $.getJSON(this.options.changeTableSortingURL, {"propertyName": propertyName, "sortingType": sortingType}, function (data) {
            if( thisRequestIndex == _thisWidget._lastRequestIndex ) { // this request was last sent request
                _thisWidget._updateData(data);
            }
        });
    },

    reload: function() {
        var _thisWidget = this;
        _thisWidget._loading();
        var thisRequestIndex = ++_thisWidget._lastRequestIndex;
        $.getJSON(this.options.getCurrentPageURL, {}, function (data) {
            if( thisRequestIndex == _thisWidget._lastRequestIndex ) { // this request was last sent request
                _thisWidget._updateData(data);
            }
        });
    },

    switchPage: function(pageNumber) {
        var _thisWidget = this;
        _thisWidget._loading();
        var thisRequestIndex = ++_thisWidget._lastRequestIndex;
        $.getJSON(this.options.switchPageURL, {pageNumber: pageNumber}, function (data) {
            if( thisRequestIndex == _thisWidget._lastRequestIndex ) { // this request was last sent request
                _thisWidget._updateData(data);
            }
        });
    },
    
    // reloads data according to current state of filter form
    reloadFilterForm: function(delay) {
        var _thisWidget = this;

        var formData = this._filterForm.serializeArray();
        if (typeof delay === 'undefined') {
            delay = this._filterReloadDelay;
        }
        if (_thisWidget._filterReloadTimeout !== null) {
            clearTimeout(_thisWidget._filterReloadTimeout);
            _thisWidget._filterReloadTimeout = null;
        }
        var reloadFunc = function () {
            _thisWidget._loading();
            var thisRequestIndex = ++_thisWidget._lastRequestIndex;
            $.getJSON(_thisWidget.options.setFilterURL, formData, function (data) {
                if( thisRequestIndex == _thisWidget._lastRequestIndex ) { // this request was last sent request
                    _thisWidget._updateData(data);
                }
            });
            _thisWidget._filterReloadTimeout = null;
        };
        if (delay > 0) {
            _thisWidget._filterReloadTimeout = setTimeout(reloadFunc, delay);
        } else {
            reloadFunc();
        }
    },

    _getSortingType: function (sortableHeaderCell) {
        var sortingType = "asc";
        if ($(sortableHeaderCell).hasClass("sorted--asc")) {
            sortingType = 'desc'
        }
        return sortingType;
    },
    
    _loading : function () {
        var columns = this.element.find("thead th").length;
        $(this._tableBodyContainer).html('<tr><td colspan="'+ columns +'"><span class="table__note--searching"><i class="fa fa-spinner fa-pulse"></i>'+this.options.loadingMessage +'</span></td></tr>');
    },

    _updateData: function (pageContent) {
        var html = "";
        if (pageContent.pagesCount == 0) {
            var columns = this.element.find("thead th").length;
            html = '<tr><td colspan="' + columns + '"><span class="table__note"><i class="fa fa-info-circle"></i>' + this.options.noRowsFoundMessage + '</span></td></tr>';
        } else {
            // handle table content
            var renderRowCallback = this.options.rowRenderer;
            for (var i = 0; i < pageContent.page.length; i++) {
                html += renderRowCallback(pageContent.page[i]);
            }
        }
        $(this._tableBodyContainer).html(html);

        bindJsDeleteRecords();

        // haldle sorting type
        this._sortableColumnsHeaderCells.removeClass('sorted--desc').removeClass('sorted--asc');
        var sortedBy = pageContent.sortedBy;
        var sortedColumnHeaderCell = this.element.find('thead th.sortable[data-property-name="' + sortedBy.propertyName + '"]');
        var type = sortedBy.sortingType;
        sortedColumnHeaderCell.addClass('sorted--' + type);

//        console.log(this._pageSwitchers.find(".page-switcher__page-count"));

        // haldle pageing
        this.pagesCount = pageContent.pagesCount;
        this._pageSwitchers.find(".page-switcher__page-count").html(pageContent.pagesCount);
        this.currentPage = pageContent.currentPage;
        this._pageSwitchers.find(".page-switcher__input").val(pageContent.currentPage).attr("max", pageContent.pagesCount);
//        console.log(this.options);
    }
});
