<?php

namespace IZON\Admin\MVC\Exceptions\Handlers;

use IZON\Admin\MVC\Exceptions\AdminPageNotFoundException;
use IZON\Logs\LogLevel;
use IZON\MVC\Exceptions\Handlers\IAppExceptionHandler;
use IZON\MVC\HttpRequest;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use Throwable;

/**
 * Handles if page is not found
 */
class AdminPageNotFoundExceptionHandler implements IAppExceptionHandler {

    protected $htmlToShow;

    function __construct($htmlToShow) {
        $this->htmlToShow = $htmlToShow;
    }

    public function getLogLevel() {
        return LogLevel::WARN;
    }

    public function handleException(Throwable $exception, ?HttpRequestInterface $request, ?HttpResponseInterface $response) : ? HttpResponseInterface {
        require $this->htmlToShow;
        return null;
    }

    public function isFor(Throwable $exception) {
        return $exception instanceof AdminPageNotFoundException;
    }
}
