<?php

namespace IZON\Admin\DI\Definition;

use DI\Scope;

use DI\Definition\Definition;

/**
 * definice pro ziskani konfigurace modulu 
 */
class ModuleConfigDefinition implements Definition {
    
    /**
     * Entry name
     * @var string
     */
    private $name;
    
    protected $moduleIdentifier;
    
    protected $paramIdentifier;

    /**
     * @param string $name   Entry name
     * @param array  $values
     */
    public function __construct($name, $moduleIdentifier, $paramIdentifier) {
        $this->name = $name;
        $this->moduleIdentifier = $moduleIdentifier;
        $this->paramIdentifier = $paramIdentifier;
    }

    /**
     * @return string Entry name
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getScope() {
        return Scope::SINGLETON;
    }

    function getModuleIdentifier() {
        return $this->moduleIdentifier;
    }
    
    function getParamIdentifier() {
        return $this->paramIdentifier;
    }

    public function setName(string $name) {
        $this->name = $name;
    }

    public function replaceNestedDefinitions(callable $replacer) {
        // no nested definitions
    }

    public function __toString() {
        return $this->moduleIdentifier .'#'. $this->name;
    }
}
