<?php

namespace IZON\Admin\Domain;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\JoinColumn;
use Doctrine\ORM\Mapping\JoinTable;
use Doctrine\ORM\Mapping\ManyToMany;
use Doctrine\ORM\Mapping\Table;

/**
 * User role in administration
 * 
 * @Entity
 * @Table(name="core_admin_roles")
 */
class AdminRole {
    
    /**
     * @Id
     * @Column
     * @GeneratedValue
     * @var int
     */
    protected $id;

    /**
     * @Column
     * @var string
     */
    protected $name;

    /**
     * @Column
     * @var string
     */
    protected $description;

    /**
     * @ManyToMany(targetEntity="AdminUser", mappedBy="roles")
     * @JoinTable(
     *     name="core_admin_users_admin_roles",
     *     joinColumns={@JoinColumn(name="fk_admin_role_id", referencedColumnName="id")},
     *     inverseJoinColumns={@JoinColumn(name="fk_admin_user_id", referencedColumnName="id")}
     * )
     * @var AdminUser[]
     */
    protected $users;
    
    /**
     * @ManyToMany(targetEntity="AdminModule", inversedBy="roles")
     * @JoinTable(
     *     name="core_admin_roles_admin_modules",
     *     joinColumns={@JoinColumn(name="fk_admin_role_id", referencedColumnName="id")},
     *     inverseJoinColumns={@JoinColumn(name="fk_admin_module_id", referencedColumnName="id")}
     * )
     * @var AdminModule[] 
     */
    protected $modules;
    
    
    public function __construct() {
        $this->users = new ArrayCollection();
        $this->modules = new ArrayCollection();
    }
    
    
/// generated getters and setters    
    function getId() {
        return $this->id;
    }

    function getName() {
        return $this->name;
    }

    function getDescription() {
        return $this->description;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setDescription($description) {
        $this->description = $description;
    }
    
    function getModules() {
        return $this->modules;
    }

    function setModules(array $modules) {
        $this->modules = $modules;
    }
}
