<?php

namespace IZON\Admin\Domain;

use Doctrine\ORM\Mapping as ORM;

/**
 * setting for some module
 *
 * @ORM\Entity()
 * @ORM\Table(name="core_admin_module_settings")
 */
class AdminModuleSetting {

    /**
     * @ORM\Id()
     * @ORM\Column()
     * @ORM\GeneratedValue()
     * @var int
     */
    protected $id;

    /**
     * @ORM\ManyToOne(targetEntity="AdminModule", inversedBy="moduleSettings")
     * @ORM\JoinColumn(name="fk_admin_module_id", referencedColumnName="id")
     * @var AdminModule
     */
    protected $module;

    /**
     * @ORM\Column()
     * unikatni identifikator daneh modulu
     * @var string
     */
    protected $paramIdentifier;

    /**
     * @ORM\Column()
     * @var string hodnota nastaveni
     */
    protected $value;

    /**
     * @ORM\Column()
     * @var string pojmenovani promene
     */
    protected $name;


// generovane gettery a settery
    function getId() {
        return $this->id;
    }

    function getModule(): AdminModule {
        return $this->module;
    }

    function getParamIdentifier() {
        return $this->paramIdentifier;
    }

    function getValue() {
        return $this->value;
    }

    function getName() {
        return $this->name;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setModule(AdminModule $module) {
        $this->module = $module;
    }

    function setParamIdentifier($paramIdentifier) {
        $this->paramIdentifier = $paramIdentifier;
    }

    function setValue($value) {
        $this->value = $value;
    }

    function setName($name) {
        $this->name = $name;
    }
}

