<?php

namespace IZON\Admin\Web\Interceptors;

use \IZON\MVC\Interceptors\Interceptor;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

use IZON\DBLocale\Domain\Locale;

use IZON\Admin\Services\SessionService;

/**
 * zpristupni prihlaseneho uzivatele pro view
 */
class HandleLoggedUserInterfaceLocaleInterceptor implements Interceptor {
    
    /**
     * @var SessionService
     */
    protected $sessionService;

    /**
     * @var string 
     */
    protected $supportedInterfaceLocalesViewName = 'supportedInterfaceLocales';
    
    /**
     * @var string 
     */
    protected $selectedUserInterfaceLocaleViewName = 'selectedUserInterfaceLocale';
    
    
    function __construct(SessionService $sessionService) {
        $this->sessionService = $sessionService;
    }
    
    
    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        /* @var $supportedInterfaceLocales Locale[] */
        $supportedInterfaceLocales = $this->sessionService->getSupportedInterfaceLocales();
        $model->putParameter($this->supportedInterfaceLocalesViewName, $supportedInterfaceLocales);
        /* @var $selectedUserInterfaceLocale Locale */
        $selectedUserInterfaceLocale = $this->sessionService->getSelectedInterfaceLocale();
        $model->putParameter($this->selectedUserInterfaceLocaleViewName, $selectedUserInterfaceLocale);
    }

    public function preHandle(HttpRequest $request) {
        $this->sessionService->setLoggedUserInterfaceLocale();
    }

}
